package org.yunchen.gb.plugin.springsecurity

import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.plugin.springsecurity.config.SpringSecurityConfigurationProperties

/*import static grails.web.http.HttpHeaders.ACCEPT_VERSION
import org.grails.web.mime.HttpServletResponseExtension
import org.grails.web.servlet.mvc.GrailsWebRequest
import grails.web.mapping.UrlMapping
import grails.web.mapping.UrlMappingInfo
import grails.web.mapping.UrlMappingsHolder*/


import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.expression.Expression
import org.springframework.expression.ParseException
import org.springframework.http.HttpMethod
import org.springframework.security.access.AccessDecisionVoter
import org.springframework.security.access.ConfigAttribute
import org.springframework.security.access.SecurityConfig
import org.springframework.security.access.expression.SecurityExpressionHandler
import org.yunchen.gb.plugin.springsecurity.web.access.expression.WebExpressionConfigAttribute

/**
 * Helper methods that use dynamic Groovy.
 *
 *
 */
class ReflectionUtils {

    private static final Logger log = LoggerFactory.getLogger(this)


    private ReflectionUtils() {
        // static only
    }

    static String getRoleAuthority(role) {
        //lookupPropertyValue role, 'authority.nameField'
        return role.authority;
    }

    static String getRequestmapUrl(requestmap) {
        //lookupPropertyValue requestmap, 'requestMap.urlField'
        return requestmap.url;
    }

    static String getRequestmapConfigAttribute(requestmap) {
        //lookupPropertyValue requestmap, 'requestMap.configAttributeField'
        return requestmap.configAttribute;
    }

    static HttpMethod getRequestmapHttpMethod(requestmap) {
        //lookupPropertyValue requestmap, 'requestMap.httpMethodField'
        return requestmap.httpMethod;
    }

    static List loadAllRequestmaps() {
        Class Requestmap = requestMapClass
        Requestmap.withTransaction {
            Requestmap.list()
        }
    }

    static boolean requestmapClassSupportsHttpMethod() {
         //'httpMethod'
         return true;
    }

    static Class getRequestMapClass() {
        String className = GbSpringUtils.getConfiginfo("gb.springsecurity.requestMap.className");
        Class Requestmap = GbSpringUtils.getDomain(className)
        //assert Requestmap, "Cannot load Requestmaps; 'requestMap.className' property '$className' is invalid"
        return Requestmap
    }

    static List asList(o) { o ? o as List : [] }


    static List<InterceptedUrl> splitMap(List<SpringSecurityConfigurationProperties.InterceptUrlMap> map) {
        map.collect { SpringSecurityConfigurationProperties.InterceptUrlMap row ->

            List tokens
            //def value = row.access
            def value = row.configAttribute
            if (value instanceof Collection || value.getClass().array) {
                tokens = value*.toString()
            }
            else { // String/GString
                tokens = [value.toString()]
            }

            def httpMethod = row.httpMethod
            if (httpMethod instanceof CharSequence) {
                httpMethod = HttpMethod.valueOf(httpMethod)
            }

            //new InterceptedUrl(row.pattern, tokens, httpMethod)
            new InterceptedUrl(row.url, tokens, httpMethod)
        }
    }

    static Collection<ConfigAttribute> buildConfigAttributes(Collection<String> tokens, boolean expressions = true) {
        Collection<ConfigAttribute> configAttributes = [] as Set

        //def ctx = getApplication().mainContext
        def ctx = GbSpringUtils.getApplicationContext();
        SecurityExpressionHandler expressionHandler = ctx.getBean('webExpressionHandler')
        AccessDecisionVoter roleVoter = ctx.getBean('roleVoter')
        AccessDecisionVoter authenticatedVoter = ctx.getBean('authenticatedVoter')

        for (String token in tokens) {
            ConfigAttribute config = new SecurityConfig(token)
            boolean supports = !expressions || token.startsWith('RUN_AS') || token.startsWith('SCOPE') ||
                    supports(config, roleVoter) || supports(config, authenticatedVoter)
            if (supports) {
                configAttributes << config
            }
            else {
                try {
                    Expression expression = expressionHandler.expressionParser.parseExpression(token)
                    configAttributes << new WebExpressionConfigAttribute(expression)
                }
                catch (ParseException e) {
                    log.error "\nError parsing expression '$token': $e.message\n", e
                    throw e
                }
            }
        }

        log.trace 'Built ConfigAttributes {} for tokens {}', configAttributes, tokens
        configAttributes
    }

    static String getGbServerURL() {
        GbSpringUtils.getConfiginfo("server.url") ?: null
    }

    private static boolean supports(ConfigAttribute config, AccessDecisionVoter<?> voter) {
        voter.supports config
    }

    private static lookupPropertyValue(o, String name) {
        o."${getConfigProperty(name)}"
    }
    static Object getConfigProperty(String name) {
        GbSpringUtils.getConfiginfo(name)
    }
    //FOR AnnotationFilterInvocationDefinition
/*    static HandlerExecutionChain matchAllUrlMappings(RequestMappingHandlerMapping requestMappingHandlerMapping, String requestUrl,
                                                    HttpServletRequest request, String extensionVersion) {
        //String method = grailsRequest.currentRequest.method
        String method = request.method
        //String version = grailsRequest.getHeader(ACCEPT_VERSION) ?: extension.getMimeTypeForRequest(grailsRequest).version
        //urlMappingsHolder.matchAll requestUrl, method, version == null ? UrlMapping.ANY_VERSION : version
         return requestMappingHandlerMapping.getHandler(request)
    }*/

    static SortedMap<Integer, String> findFilterChainNames(ConfigObject conf) {
        GbSpringSecurityUtils.findFilterChainNames conf.filterChain.filterNames,
                conf.secureChannel.definition as boolean, conf.ipRestrictions as boolean, conf.useX509,
                conf.useDigestAuth, conf.useBasicAuth, conf.useSwitchUserFilter
    }
}
