/* Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.yunchen.gb.plugin.springsecurity.access.vote

import org.springframework.security.access.ConfigAttribute

import groovy.transform.CompileStatic

/**
 * @author <a href='mailto:burt@burtbeckwith.com'>Burt Beckwith</a>
 */
@CompileStatic
class ClosureConfigAttribute implements ConfigAttribute {

    private static final long serialVersionUID = 1

    final Closure<?> closure

    /**
     * Constructor.
     * @param closure the closure
     */
    ClosureConfigAttribute(Closure<?> closure) {
        this.closure = closure
    }

    String getAttribute() {}
}
