package org.yunchen.gb.plugin.springsecurity.config


import org.springframework.security.core.AuthenticationException
import org.springframework.security.web.WebAttributes
import org.springframework.security.web.authentication.AuthenticationFailureHandler
import org.springframework.util.ClassUtils
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.core.annotation.GbBootstrap
import org.yunchen.gb.plugin.springsecurity.GbSpringSecurityUtils
import org.yunchen.gb.plugin.springsecurity.event.AppSecurityAuthFailureEvent

import javax.servlet.ServletException
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse
import javax.servlet.http.HttpSession

/**
 * Created by @Author:xiaopeng on 2017/6/21.
 */
class FailureLoginHandler implements AuthenticationFailureHandler {

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        GbSpringUtils.publishEvent(new AppSecurityAuthFailureEvent([request:request, response:response, authenticationException:authenticationException]));
        //循环执行 GbBootstrap bean的onAuthenticationFailure
        try{
            //casSuccessLoginHandler.startupBean=this.applicationContext.getBean("startup");
            def startups = GbSpringUtils.applicationContext.getBeansWithAnnotation(GbBootstrap);
            if(startups && startups.size()>0){
                startups.each {k,v->
                    Class clazz=v?.class
                    if(ClassUtils.isCglibProxyClass(clazz)){
                        clazz=ClassUtils.getUserClass(clazz)
                    }
                    if(clazz.methods.collect {it.name}.contains("onAuthenticationFailure")){
                        try{
                            v?.onAuthenticationFailure(request,response,authenticationException);
                        }catch(e1){
                            e1.printStackTrace();
                        }
                    }
                }
            }
        }catch(e){
            e.printStackTrace();
        }

        String url=request.contextPath+GbSpringUtils.getConfiginfo("gb.springsecurity.failureHandler.defaultFailureUrl");
        String ajaxurl=request.contextPath+GbSpringUtils.getConfiginfo("gb.springsecurity.failureHandler.defaultAjaxFailureUrl");
        HttpSession session=request.getSession();
        session.setAttribute(WebAttributes.AUTHENTICATION_EXCEPTION,authenticationException);
        //request.getRequestDispatcher(url).forward(request,response);
        if(GbSpringSecurityUtils.isAjax(request)){
            response.sendRedirect(ajaxurl);
        }else{
            response.sendRedirect(url);
        }
    }
}
