package org.yunchen.gb.plugin.springsecurity.config

import org.springframework.boot.context.properties.ConfigurationProperties

/**
 * Created by @Author:xiaopeng on 2017/6/21.
 * 读取yml文件的系统安全配置信息
 */

@ConfigurationProperties(prefix = "gb.springsecurity")
class SpringSecurityConfigurationProperties {
    boolean active=true;
    private String csrf;
    private String cors;
    List<Map> headers=[];
    private String ajaxHeader;
    private Password password;
    private String securityConfigType;
    List<InterceptUrlMap> interceptUrlMaps=[];
    boolean authorityWithoutDB
    List<AuthorityUser> authorityMaps=[];
    boolean requestMapWithoutDB
    private UserLookup userLookup;
    private Authority authority;
    private RequestMap requestMap;
    private Apf apf;
    private Auth auth;
    private Adh adh;
    private FailureHandler failureHandler;
    private SuccessHandler successHandler;
    private SessionAuthenticationStrategy sessionAuthenticationStrategy;
    private Logout logout;
    private boolean useBasicAuth;
    private String frameOptions;
    private CorsConfig corsConfig;
    //add sessionFixationPrevention
    boolean useSessionFixationPrevention = true;
    SessionFixationPrevention sessionFixationPrevention=new SessionFixationPrevention();

    Scale scale=new Scale();
    public static class Scale {
        boolean enableCookie=false;
        boolean httpOnly=true;
        boolean secure=false;
        int tokenValiditySeconds=1800;
        String domainName;
    }
    public static class AuthorityUser{
        String id
        String username
        String password
        boolean enabled
        boolean accountExpired
        boolean accountLocked
        boolean passwordExpired
        List<String> authorities
    }
    public static class InterceptUrlMap{
        String url
        String  configAttribute
        String httpMethod
    }

    CorsConfig getCorsConfig() {
        return corsConfig
    }

    void setCorsConfig(CorsConfig corsConfig) {
        this.corsConfig = corsConfig
    }
    public static class SessionFixationPrevention{
        public boolean migrate=true;
        public boolean alwaysCreateSession;
        public boolean none=true;
    }
    public static class CorsConfig{
        boolean getAllowCredentials() {
            return allowCredentials
        }

        void setAllowCredentials(boolean allowCredentials) {
            this.allowCredentials = allowCredentials
        }

        String getAllowedOrigins() {
            return allowedOrigins
        }

        void setAllowedOrigins(String allowedOrigins) {
            this.allowedOrigins = allowedOrigins
        }

        String getAllowedHeaders() {
            return allowedHeaders
        }

        void setAllowedHeaders(String allowedHeaders) {
            this.allowedHeaders = allowedHeaders
        }

        String getAllowedMethods() {
            return allowedMethods
        }

        void setAllowedMethods(String allowedMethods) {
            this.allowedMethods = allowedMethods
        }
        private boolean allowCredentials
        private String allowedOrigins
        private String allowedHeaders
        private String allowedMethods
        private String corsPath

        String getCorsPath() {
            return corsPath
        }

        void setCorsPath(String corsPath) {
            this.corsPath = corsPath
        }
    }
    String getFrameOptions() {
        return frameOptions
    }

    void setFrameOptions(String frameOptions) {
        this.frameOptions = frameOptions
    }

    boolean getUseBasicAuth() {
        return useBasicAuth
    }

    void setUseBasicAuth(boolean useBasicAuth) {
        this.useBasicAuth = useBasicAuth
    }

    Basic getBasic() {
        return basic
    }

    void setBasic(Basic basic) {
        this.basic = basic
    }
    private Basic basic;
    public static class Basic {
        String getRealmName() {
            return realmName
        }

        void setRealmName(String realmName) {
            this.realmName = realmName
        }
        private String realmName;

        String getCredentialsCharset() {
            return credentialsCharset
        }

        void setCredentialsCharset(String credentialsCharset) {
            this.credentialsCharset = credentialsCharset
        }
        private String credentialsCharset;
    }
    String getCsrf() {
        return csrf
    }

    void setCsrf(String csrf) {
        this.csrf = csrf
    }

    String getCors() {
        return cors
    }

    void setCors(String cors) {
        this.cors = cors
    }
    Logout getLogout() {
        return logout
    }

    void setLogout(Logout logout) {
        this.logout = logout
    }

    public static class Logout {
        private String afterLogoutUrl;
        private String filterProcessesUrl;

        String getAfterLogoutUrl() {
            return afterLogoutUrl
        }

        void setAfterLogoutUrl(String afterLogoutUrl) {
            this.afterLogoutUrl = afterLogoutUrl
        }

        String getFilterProcessesUrl() {
            return filterProcessesUrl
        }

        void setFilterProcessesUrl(String filterProcessesUrl) {
            this.filterProcessesUrl = filterProcessesUrl
        }
    }
    FailureHandler getFailureHandler() {
        return failureHandler
    }

    void setFailureHandler(FailureHandler failureHandler) {
        this.failureHandler = failureHandler
    }

    SuccessHandler getSuccessHandler() {
        return successHandler
    }

    void setSuccessHandler(SuccessHandler successHandler) {
        this.successHandler = successHandler
    }

    public static class FailureHandler {
        String getDefaultFailureUrl() {
            return defaultFailureUrl
        }

        void setDefaultFailureUrl(String defaultFailureUrl) {
            this.defaultFailureUrl = defaultFailureUrl
        }
        private String defaultFailureUrl;
    }
    public static class SuccessHandler {
        String getDefaultTargetUrl() {
            return defaultTargetUrl
        }

        void setDefaultTargetUrl(String defaultTargetUrl) {
            this.defaultTargetUrl = defaultTargetUrl
        }

        String getAjaxSuccessUrl() {
            return ajaxSuccessUrl
        }

        void setAjaxSuccessUrl(String ajaxSuccessUrl) {
            this.ajaxSuccessUrl = ajaxSuccessUrl
        }

        String getSystemloginRecord() {
            return systemloginRecord
        }

        void setSystemloginRecord(String systemloginRecord) {
            this.systemloginRecord = systemloginRecord
        }
        private String defaultTargetUrl;
        private String ajaxSuccessUrl;
        private String systemloginRecord;
    }
    SessionAuthenticationStrategy getSessionAuthenticationStrategy() {
        return sessionAuthenticationStrategy
    }

    void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        this.sessionAuthenticationStrategy = sessionAuthenticationStrategy
    }


    Apf getApf() {
        return apf
    }

    void setApf(Apf apf) {
        this.apf = apf
    }

    Auth getAuth() {
        return auth
    }

    void setAuth(Auth auth) {
        this.auth = auth
    }

    Adh getAdh() {
        return adh
    }

    void setAdh(Adh adh) {
        this.adh = adh
    }

    String getAjaxHeader() {
        return ajaxHeader
    }

    void setAjaxHeader(String ajaxHeader) {
        this.ajaxHeader = ajaxHeader
    }

    Password getPassword() {
        return password
    }

    void setPassword(Password password) {
        this.password = password
    }

    String getSecurityConfigType() {
        return securityConfigType
    }

    void setSecurityConfigType(String securityConfigType) {
        this.securityConfigType = securityConfigType
    }

    UserLookup getUserLookup() {
        return userLookup
    }

    void setUserLookup(UserLookup userLookup) {
        this.userLookup = userLookup
    }

    Authority getAuthority() {
        return authority
    }

    void setAuthority(Authority authority) {
        this.authority = authority
    }

    RequestMap getRequestMap() {
        return requestMap
    }

    void setRequestMap(RequestMap requestMap) {
        this.requestMap = requestMap
    }

    public static class UserLookup {
        String getUserDomainClassName() {
            return userDomainClassName
        }

        void setUserDomainClassName(String userDomainClassName) {
            this.userDomainClassName = userDomainClassName
        }

        String getAuthorityJoinClassName() {
            return authorityJoinClassName
        }

        void setAuthorityJoinClassName(String authorityJoinClassName) {
            this.authorityJoinClassName = authorityJoinClassName
        }
        private String userDomainClassName;
        private String authorityJoinClassName;
    }
    public static class Password {
        String getAlgorithm() {
            return algorithm
        }

        void setAlgorithm(String algorithm) {
            this.algorithm = algorithm
        }

        boolean getEncodeHashAsBase64() {
            return encodeHashAsBase64
        }

        void setEncodeHashAsBase64(boolean encodeHashAsBase64) {
            this.encodeHashAsBase64 = encodeHashAsBase64
        }
        private String algorithm;
        private String sm4Key;

        String getSm4Key() {
            return sm4Key
        }

        void setSm4Key(String sm4Key) {
            this.sm4Key = sm4Key
        }
        private boolean encodeHashAsBase64;
    }
    public static class Authority {
        String getClassName() {
            return className
        }

        void setClassName(String className) {
            this.className = className
        }
        private String className;
    }
    public static class RequestMap {
        String getClassName() {
            return className
        }

        void setClassName(String className) {
            this.className = className
        }
        private String className;
    }
    public static class Apf {
        String getFilterProcessesUrl() {
            return filterProcessesUrl
        }

        void setFilterProcessesUrl(String filterProcessesUrl) {
            this.filterProcessesUrl = filterProcessesUrl
        }
        private String filterProcessesUrl;
    }
    public static class Auth {
        String getLoginFormUrl() {
            return loginFormUrl
        }

        void setLoginFormUrl(String loginFormUrl) {
            this.loginFormUrl = loginFormUrl
        }

        String getAjaxLoginFormUrl() {
            return ajaxLoginFormUrl
        }

        void setAjaxLoginFormUrl(String ajaxLoginFormUrl) {
            this.ajaxLoginFormUrl = ajaxLoginFormUrl
        }

        boolean getUseForward() {
            return useForward
        }

        void setUseForward(boolean useForward) {
            this.useForward = useForward
        }
        private String loginFormUrl;
        private String ajaxLoginFormUrl;
        private boolean useForward;
        private String alreadyLogin;

        String getAlreadyLogin() {
            return alreadyLogin
        }

        void setAlreadyLogin(String alreadyLogin) {
            this.alreadyLogin = alreadyLogin
        }
    }
    public static class Adh {
        String getErrorPage() {
            return errorPage
        }

        void setErrorPage(String errorPage) {
            this.errorPage = errorPage
        }

        String getAjaxErrorPage() {
            return ajaxErrorPage
        }

        void setAjaxErrorPage(String ajaxErrorPage) {
            this.ajaxErrorPage = ajaxErrorPage
        }

        boolean getUseForward() {
            return useForward
        }

        void setUseForward(boolean useForward) {
            this.useForward = useForward
        }
        private String errorPage;
        private String ajaxErrorPage;
        private boolean useForward;
    }
    public static class SessionAuthenticationStrategy{
        private int maximumSessions=-1;

        boolean getMaxSessionsPreventsLogin() {
            return maxSessionsPreventsLogin
        }

        void setMaxSessionsPreventsLogin(boolean maxSessionsPreventsLogin) {
            this.maxSessionsPreventsLogin = maxSessionsPreventsLogin
        }
        private boolean maxSessionsPreventsLogin=false;

        String getExpiredUrl() {
            return expiredUrl
        }

        void setExpiredUrl(String expiredUrl) {
            this.expiredUrl = expiredUrl
        }
        private String expiredUrl="/login/concurrentSession";

        int getMaximumSessions() {
            return maximumSessions
        }

        void setMaximumSessions(int maximumSessions) {
            this.maximumSessions = maximumSessions
        }


    }
}
