package org.yunchen.gb.plugin.springsecurity.config


import org.springframework.security.core.Authentication
import org.springframework.security.web.authentication.AuthenticationSuccessHandler
import org.springframework.security.web.savedrequest.SavedRequest
import org.springframework.util.ClassUtils
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.core.annotation.GbBootstrap
import org.yunchen.gb.plugin.springsecurity.GbSpringSecurityUtils
import org.yunchen.gb.plugin.springsecurity.event.AppSecurityAuthSuccessEvent

import javax.servlet.ServletException
import javax.servlet.http.Cookie
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

/**
 * Created by @Author:xiaopeng on 2017/6/21.
 */
class SuccessLoginHandler implements AuthenticationSuccessHandler {
    SpringSecurityConfigurationProperties springSecurityConfigurationProperties;
    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        // 2020-02-06 xp add
        // write auth info TO cookie
        if(springSecurityConfigurationProperties?.scale?.enableCookie){
            Cookie unameCookie=new Cookie("EaAuthenticationUserName",authentication?.principal?.username);
            if(springSecurityConfigurationProperties.scale.secure){
                unameCookie.secure=true;
            }
            if(springSecurityConfigurationProperties.scale.httpOnly){
                unameCookie.setHttpOnly(true)
            }
            if(springSecurityConfigurationProperties.scale.tokenValiditySeconds){
                unameCookie.setMaxAge(springSecurityConfigurationProperties.scale.tokenValiditySeconds);
            }
            if(springSecurityConfigurationProperties.scale.domainName && springSecurityConfigurationProperties.scale.domainName.trim().size()>0){
                unameCookie.domain=springSecurityConfigurationProperties.scale.domainName;
            }
            unameCookie.path="/";
            response.addCookie(unameCookie);
            Cookie timeCookie=new Cookie("EaAuthenticationExpireTime",((new Date().time)+springSecurityConfigurationProperties.scale.tokenValiditySeconds).toString())
            if(springSecurityConfigurationProperties.scale.secure){
                timeCookie.secure=true;
            }
            if(springSecurityConfigurationProperties.scale.httpOnly){
                timeCookie.setHttpOnly(true)
            }
            if(springSecurityConfigurationProperties.scale.tokenValiditySeconds){
                timeCookie.setMaxAge(springSecurityConfigurationProperties.scale.tokenValiditySeconds);
            }
            if(springSecurityConfigurationProperties.scale.domainName && springSecurityConfigurationProperties.scale.domainName.trim().size()>0){
                timeCookie.domain=springSecurityConfigurationProperties.scale.domainName;
            }
            timeCookie.path="/";
            response.addCookie(timeCookie);
        }
        //发布登录成功事件
        GbSpringUtils.publishEvent(new AppSecurityAuthSuccessEvent([request:request, response:response, authentication:authentication]))
        //循环执行 GbBootstrap bean的onAuthenticationSuccess
        try{
            //casSuccessLoginHandler.startupBean=this.applicationContext.getBean("startup");
            def startups = GbSpringUtils.applicationContext.getBeansWithAnnotation(GbBootstrap);
            if(startups && startups.size()>0){
                startups.each {k,v->
                    Class clazz=v?.class
                    if(ClassUtils.isCglibProxyClass(clazz)){
                        clazz=ClassUtils.getUserClass(clazz)
                    }
                    if(clazz.methods.collect {it.name}.contains("onAuthenticationSuccess")){
                        try{
                            v?.onAuthenticationSuccess(request,response,authentication);
                        }catch(e1){
                            e1.printStackTrace();
                        }
                    }
                }
            }
        }catch(e){
            e.printStackTrace();
        }
        //读取是否有之前拦截的url SPRING_SECURITY_SAVED_REQUEST
        SavedRequest savedRequest = (SavedRequest)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        //判段是否ajax
        if(GbSpringSecurityUtils.isAjax(request)){
            String url=request.contextPath+GbSpringUtils.getConfiginfo("gb.springsecurity.successHandler.ajaxSuccessUrl");
            if(savedRequest){
                url=savedRequest.redirectUrl;
            }
            request.getRequestDispatcher(url).forward(request,response);
        }else{
            String url=request.contextPath+GbSpringUtils.getConfiginfo("gb.springsecurity.successHandler.defaultTargetUrl")
            if(savedRequest){
                url=savedRequest.redirectUrl;
            }
            response?.sendRedirect(url);
        }

    }
}
