package org.yunchen.gb.plugin.springsecurity.config.filter


import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler
import org.springframework.web.filter.OncePerRequestFilter
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.plugin.springsecurity.GbSpringSecurityService

import javax.servlet.FilterChain
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse


/**
 * Created by @Author:xiaopeng on 2017/6/26.
 */
class AlreadyLoginFilter extends OncePerRequestFilter {

    private SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler()
    @Override
    public void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) {
        if(GbSpringUtils.getConfiginfo("gb.springsecurity.auth.alreadyLogin") && req.getRequestURI()==(req.contextPath+GbSpringUtils.getConfiginfo("gb.springsecurity.apf.filterProcessesUrl"))){
            GbSpringSecurityService gbSpringSecurityService=GbSpringUtils.getBean("gbSpringSecurityService");
            if(gbSpringSecurityService.isLoggedIn()){
                String url=req.contextPath+GbSpringUtils.getConfiginfo("gb.springsecurity.auth.alreadyLogin");
                res.sendRedirect(url);
                // Redirect user to login page
                //failureHandler.setDefaultFailureUrl(failureUrl)
                //failureHandler.onAuthenticationFailure(req, res, new CaptchaVerificationFailedException("Captcha invalid"))
                return;
            }
        }
        chain.doFilter(req, res);
    }

}
