package org.yunchen.gb.plugin.springsecurity.config.filter


import groovy.transform.CompileStatic
import groovy.util.logging.Slf4j
import org.springframework.web.filter.GenericFilterBean

import javax.servlet.FilterChain
import javax.servlet.ServletException
import javax.servlet.ServletRequest
import javax.servlet.ServletResponse
import javax.servlet.http.Cookie
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

/**
 * Created by @Author:xiaopeng on 2020/02/07.
 * read auth info from cookie
 */
@Slf4j
@CompileStatic
class ScaleCookieLogoutFilter extends GenericFilterBean {
    String endpointUrl
    @Override
    void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = request as HttpServletRequest
        HttpServletResponse httpResponse = response as HttpServletResponse
        String actualUri =  httpRequest.requestURI - httpRequest.contextPath

        //Only apply filter to the configured URL
        if (actualUri == endpointUrl) {
            //clear cookie
            httpRequest.setAttribute("EaAuthenticationCookieLogout","active");
            Cookie usernameCookie=new Cookie("EaAuthenticationUserName",null);
            usernameCookie.maxAge=0;
            usernameCookie.path='/';
            httpResponse.addCookie(usernameCookie);
            Cookie expireTimeCookie=new Cookie("EaAuthenticationExpireTime","0");
            expireTimeCookie.maxAge=0;
            expireTimeCookie.path='/';
            httpResponse.addCookie(expireTimeCookie);
        }
        chain.doFilter(request, response);
    }
}
