package org.yunchen.gb.plugin.springsecurity.config.filter


import org.yunchen.gb.plugin.springsecurity.config.SpringSecurityConfigurationProperties
import groovy.transform.CompileStatic
import groovy.util.logging.Slf4j
import org.springframework.web.filter.GenericFilterBean
import org.yunchen.gb.plugin.springsecurity.GbSpringSecurityService

import javax.servlet.FilterChain
import javax.servlet.ServletException
import javax.servlet.ServletRequest
import javax.servlet.ServletResponse
import javax.servlet.http.Cookie
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse
/**
 * Created by @Author:xiaopeng on 2020/02/07.
 * read auth info from cookie
 */
@Slf4j
@CompileStatic
class ScaleCookieValidationFilter extends GenericFilterBean {
    GbSpringSecurityService gbSpringSecurityService
    SpringSecurityConfigurationProperties securityproperties;
    @Override
    void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if(securityproperties?.scale?.enableCookie){
            HttpServletRequest httpRequest = request as HttpServletRequest
            HttpServletResponse httpResponse = response as HttpServletResponse
            if(!gbSpringSecurityService.isLoggedIn()){
                String eaAuthenticationCookieLogout=(String)httpRequest.getAttribute("EaAuthenticationCookieLogout");
                if(eaAuthenticationCookieLogout && eaAuthenticationCookieLogout=='active'){
                    //当前线程在 /logoff后，不能再次自动认证
                }else{
                    List<Cookie> cookies= httpRequest.getCookies()?.toList();
                    String username = cookies?.find {it.name=='EaAuthenticationUserName'}?.value;
                    Long expireTime = cookies?.find {it.name=='EaAuthenticationExpireTime'}?.value?.toLong();
                    if(username && expireTime){
                        if((new Date().time)<expireTime?.longValue()){
                            gbSpringSecurityService.reauthenticate(username)
                        }
                    }
                }

            }
        }
        chain.doFilter(request, response);
    }
}
