package org.yunchen.gb.plugin.springsecurity.crypto.password


import org.springframework.security.crypto.password.PasswordEncoder
import org.springframework.util.ClassUtils
import org.springframework.web.context.request.RequestContextHolder
import org.springframework.web.context.request.ServletRequestAttributes
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.core.annotation.GbBootstrap
import org.yunchen.gb.plugin.springsecurity.GbSpringSecurityBean
import org.yunchen.gb.plugin.springsecurity.dao.provider.GbDaoAuthenticationProvider
import org.yunchen.gb.plugin.springsecurity.userdetails.CoreUser

/**
 * 自定义的PasswordEncoder，目的是提供可以自动加载GbBootstrap标注的类里的方法来实现
 * 可扩展的加密和验签功能
 *
 * @author xiaopeng
 */
class CustomPasswordEncoder implements PasswordEncoder {
    public String encode(CoreUser currentLoadUser, CharSequence rawPassword) {
        //gb.springsecurity.password.algorithm=Custom
        //读取yml中是否定义自处理方法 gb.springsecurity.password.useCustomMethodAlgorithm=MD5
        PasswordEncoder passwordEncoder;
        GbSpringSecurityBean gbSpringSecurityBean=(GbSpringSecurityBean) GbSpringUtils.getBean(GbSpringSecurityBean.class)
        Map encoders=gbSpringSecurityBean?.encoders;
        passwordEncoder=encoders[GbSpringUtils.getConfiginfo('gb.springsecurity.password.useCustomMethodAlgorithm')]
        def startups = GbSpringUtils.applicationContext.getBeansWithAnnotation(GbBootstrap);
        String customPasswordEncoder="customPasswordEncoder"
        String passwordStr="";
        if(startups && startups.size()>0){
            startups.each {k,v->
                Class clazz=v?.class
                if(ClassUtils.isCglibProxyClass(clazz)){
                    clazz=ClassUtils.getUserClass(clazz)
                }
                if(clazz.methods.collect {it.name}.contains(customPasswordEncoder)){
                    try{
                        passwordStr=v."${customPasswordEncoder}"(currentLoadUser,passwordEncoder,rawPassword);
                    }catch(e1){
                        e1.printStackTrace();
                    }
                }
            }
        }
        return passwordStr;
    }
    public String encode(CharSequence rawPassword) {
        //gb.springsecurity.password.algorithm=Custom
        //读取yml中是否定义自处理方法 gb.springsecurity.password.useCustomMethodAlgorithm=MD5
        CoreUser currentLoadUser= ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes())?.getRequest()?.getAttribute(GbDaoAuthenticationProvider.eaCurrentLoadUserTag)
        String passwordStr=this.encode(currentLoadUser,rawPassword)
        ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes())?.getRequest()?.removeAttribute(GbDaoAuthenticationProvider.eaCurrentLoadUserTag)
        return passwordStr;
    }
    public boolean matches(CoreUser currentLoadUser,CharSequence rawPassword, String encodedPassword) {
        boolean flag = false;
        try {
            GbSpringSecurityBean gbSpringSecurityBean=(GbSpringSecurityBean)GbSpringUtils.getBean(GbSpringSecurityBean.class)
            Map encoders=gbSpringSecurityBean?.encoders;
            PasswordEncoder passwordEncoder=encoders[GbSpringUtils.getConfiginfo('gb.springsecurity.password.useCustomMethodAlgorithm')]
            def startups = GbSpringUtils.applicationContext.getBeansWithAnnotation(GbBootstrap);
            String customPasswordmatches="customPasswordMatches"
            if(startups && startups.size()>0){
                startups.each {k,v->
                    Class clazz=v?.class
                    if(ClassUtils.isCglibProxyClass(clazz)){
                        clazz=ClassUtils.getUserClass(clazz)
                    }
                    if(clazz.methods.collect {it.name}.contains(customPasswordmatches)){
                        try{
                            flag=v."${customPasswordmatches}"(currentLoadUser,passwordEncoder,rawPassword,encodedPassword);
                        }catch(e1){
                            e1.printStackTrace();
                        }
                    }
                }
            }
            //flag=passwordEncoder.matches(rawPassword,encodedPassword)
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        boolean flag = false;
        CoreUser currentLoadUser= ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes())?.getRequest()?.getAttribute(GbDaoAuthenticationProvider.eaCurrentLoadUserTag)
        flag=this.matches(currentLoadUser,rawPassword,encodedPassword)
        ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes())?.getRequest()?.removeAttribute(GbDaoAuthenticationProvider.eaCurrentLoadUserTag)
        return flag;
    }
}
