package org.yunchen.gb.plugin.springsecurity.crypto.password


import org.springframework.security.crypto.password.DelegatingPasswordEncoder
import org.springframework.security.crypto.password.PasswordEncoder
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.plugin.springsecurity.userdetails.CoreUser

/**
 * 自定义的DelegatingPasswordEncoder，目的是提供可以通过配置决定是否增加prefix+ idforencoder
 *
 * @author xiaopeng
 */
class GbDelegatingPasswordEncoder extends DelegatingPasswordEncoder{
    private static final String PREFIXInGb = "{";
    private static final String SUFFIXInGb = "}";
    private final String idForEncodeInGb;
    private final PasswordEncoder passwordEncoderForEncodeInGb;
    private final Map<String, PasswordEncoder> idToPasswordEncoderInGb;
    private PasswordEncoder defaultPasswordEncoderForMatchesInGb = new GbUnmappedIdPasswordEncoder();
    public GbDelegatingPasswordEncoder(String idForEncode, Map<String, PasswordEncoder> idToPasswordEncoder) {
        super(idForEncode,idToPasswordEncoder)
        this.idForEncodeInGb=idForEncode
        this.passwordEncoderForEncodeInGb = idToPasswordEncoder.get(idForEncode);
        this.idToPasswordEncoderInGb = idToPasswordEncoder;
    }

    public String encode(CoreUser currentLoadUser, CharSequence rawPassword) {
        String encodePassword;
        if(passwordEncoderForEncodeInGb instanceof CustomPasswordEncoder){
            encodePassword= ((CustomPasswordEncoder)this.passwordEncoderForEncodeInGb).encode(currentLoadUser,rawPassword)
        }else{
            encodePassword= this.passwordEncoderForEncodeInGb.encode(rawPassword)
        }
        if(GbSpringUtils.getConfiginfo("gb.springsecurity.password.withoutIdPrefix")?.trim()?.equals('true')){
            return encodePassword;
        }
        return PREFIXInGb + this.idForEncodeInGb + SUFFIXInGb + encodePassword;
    }
    @Override
    public String encode(CharSequence rawPassword) {
        String encodePassword= this.passwordEncoderForEncodeInGb.encode(rawPassword)
        if(GbSpringUtils.getConfiginfo("gb.springsecurity.password.withoutIdPrefix")?.trim()?.equals('true')){
            return encodePassword;
        }
        return PREFIXInGb + this.idForEncodeInGb + SUFFIXInGb + encodePassword;
    }


    public boolean matches(CoreUser currentLoadUser,CharSequence rawPassword, String prefixEncodedPassword) {
        if (rawPassword == null && prefixEncodedPassword == null) {
            return true;
        }
        String id = selfExtractId(prefixEncodedPassword);
        PasswordEncoder delegate = this.idToPasswordEncoderInGb.get(id);
        if (delegate == null) {
            return this.defaultPasswordEncoderForMatchesInGb.matches(rawPassword, prefixEncodedPassword);
        }
        String encodedPassword = extractEncodedPassword(prefixEncodedPassword);
        if(delegate instanceof CustomPasswordEncoder){
            return ((CustomPasswordEncoder)delegate).matches(currentLoadUser,rawPassword, encodedPassword);
        }else{
            return delegate.matches(rawPassword, encodedPassword);
        }

    }
    @Override
    public boolean matches(CharSequence rawPassword, String prefixEncodedPassword) {
        if (rawPassword == null && prefixEncodedPassword == null) {
            return true;
        }
        String id = selfExtractId(prefixEncodedPassword);
        PasswordEncoder delegate = this.idToPasswordEncoderInGb.get(id);
        if (delegate == null) {
            return this.defaultPasswordEncoderForMatchesInGb.matches(rawPassword, prefixEncodedPassword);
        }
        String encodedPassword = extractEncodedPassword(prefixEncodedPassword);
        return delegate.matches(rawPassword, encodedPassword);
    }

    private String selfExtractId(String prefixEncodedPassword) {
        if(GbSpringUtils.getConfiginfo("gb.springsecurity.password.withoutIdPrefix")?.trim()?.equals('true')){
            return GbSpringUtils.getConfiginfo("gb.springsecurity.password.algorithm");
        }
        if (prefixEncodedPassword == null) {
            return null;
        }
        int start = prefixEncodedPassword.indexOf(PREFIXInGb);
        if (start != 0) {
            return null;
        }
        int end = prefixEncodedPassword.indexOf(SUFFIXInGb, start);
        if (end < 0) {
            return null;
        }
        return prefixEncodedPassword.substring(start + 1, end);
    }
    //因为去掉{} 标注，按方法逻辑会返回正确的全部字符
    @Override
    private String extractEncodedPassword(String prefixEncodedPassword) {
        int start = prefixEncodedPassword.indexOf(SUFFIXInGb);
        return prefixEncodedPassword.substring(start + 1);
    }

    /**
     * Default {@link PasswordEncoder} that throws an exception that a id could
     */
    private class GbUnmappedIdPasswordEncoder implements PasswordEncoder {

        @Override
        public String encode(CharSequence rawPassword) {
            throw new UnsupportedOperationException("encode is not supported");
        }

        @Override
        public boolean matches(CharSequence rawPassword,
                               String prefixEncodedPassword) {
            String id = selfExtractId(prefixEncodedPassword);
            throw new IllegalArgumentException("There is no PasswordEncoder mapped for the id \"" + id + "\"");
        }
    }
}
