package org.yunchen.gb.plugin.springsecurity.crypto.password

import org.bouncycastle.crypto.digests.SM3Digest
import org.bouncycastle.jce.provider.BouncyCastleProvider
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils
import org.springframework.security.crypto.password.PasswordEncoder

import java.security.Security

class Sm3PasswordEncoder implements PasswordEncoder {
    private final String ENCODING = "UTF-8";

    Sm3PasswordEncoder() {
       Security.addProvider(new BouncyCastleProvider());
    }
    /**
     * Encodes the rawPass using a MessageDigest. If a salt is specified it will be merged
     * with the password before encoding.
     *
     * @param rawPassword The plain text password
     * @return Hex string of password digest (or base64 encoded string if
     * encodeHashAsBase64 is enabled.
     */
    public String encode(CharSequence rawPassword) {
        // 将返回的hash值转换成16进制字符串
        String resultHexString = "";
        try {
            // 将字符串转换成byte数组
            byte[] srcData = rawPassword.toString()getBytes(ENCODING);
            // 调用hash()
            byte[] resultHash = hash(srcData);
            // 将返回的hash值转换成16进制字符串
            resultHexString = ByteUtils.toHexString(resultHash);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return resultHexString;
    }
/**
 * 返回长度=32的byte数组
 * @explain 生成对应的hash值
 * @param srcData
 * @return
 */
    private byte[] hash(byte[] srcData) {
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }
    /**
     * Takes a previously encoded password and compares it with a rawpassword after mixing
     * in the salt and encoding that value
     *
     * @param rawPassword plain text password
     * @param encodedPassword previously encoded password
     * @return true or false
     */
    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        boolean flag = false;
        try {
            byte[] srcData = rawPassword.toString().getBytes(ENCODING);
            byte[] sm3Hash = ByteUtils.fromHexString(encodedPassword);
            byte[] newHash = hash(srcData);
            if (Arrays.equals(newHash, sm3Hash)){
                flag = true;
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return flag;
    }
}
