package org.yunchen.gb.plugin.springsecurity.dao.provider

import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.plugin.springsecurity.crypto.password.GbDelegatingPasswordEncoder
import org.yunchen.gb.plugin.springsecurity.userdetails.CoreUser
import org.springframework.security.authentication.BadCredentialsException
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken
import org.springframework.security.authentication.dao.DaoAuthenticationProvider
import org.springframework.security.core.AuthenticationException
import org.springframework.security.core.userdetails.UserDetails
import org.springframework.web.context.request.RequestContextHolder
import org.springframework.web.context.request.ServletRequestAttributes

/**
 * 自定义的daoAuthenticationProvider，目的是提供如下功能
 * 1. 可配置的加密算法(包含userdetail的属性参与加密，如userId)
 * 2. 可配置去掉加密后的prefixString,如{md5}
 * 3. 用户定位，loadbyusername时可以是多列匹配（如用户名，手机号，邮箱名称） 在EaUserDetailsService类中处理
 *
 * 部分代码摘抄自DaoAuthenticationProvider(spring-security-core.5.1.5.release.jar)
 * @author xiaopeng
 */
class GbDaoAuthenticationProvider extends DaoAuthenticationProvider {

        public static final eaCurrentLoadUserTag="ea-springsecurity-current-load-user"

        public GbDaoAuthenticationProvider(){

        }
    // ~ Methods
        // ========================Md5Encoder.encode(plainTextPassword,currentLoadUser.id)================================================================================

        @SuppressWarnings("deprecation")
        protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
            if (authentication.getCredentials() == null) {
                logger.debug("Authentication failed: no credentials provided");

                throw new BadCredentialsException(messages.getMessage(
                        "AbstractUserDetailsAuthenticationProvider.badCredentials",
                        "Bad credentials"));
            }

            String presentedPassword = authentication.getCredentials().toString();
            if(GbSpringUtils.getConfiginfo("gb.springsecurity.password.algorithm")?.equals('custom') && passwordEncoder instanceof GbDelegatingPasswordEncoder){
                ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes())?.getRequest()?.setAttribute(eaCurrentLoadUserTag,(CoreUser)userDetails)
                if (!passwordEncoder.matches((CoreUser)userDetails,presentedPassword, userDetails.getPassword())) {
                    logger.debug("Authentication failed: password does not match stored value");

                    throw new BadCredentialsException(messages.getMessage(
                            "AbstractUserDetailsAuthenticationProvider.badCredentials",
                            "Bad credentials"));
                }
            }else{
                if (!passwordEncoder.matches(presentedPassword, userDetails.getPassword())) {
                    logger.debug("Authentication failed: password does not match stored value");

                    throw new BadCredentialsException(messages.getMessage(
                            "AbstractUserDetailsAuthenticationProvider.badCredentials",
                            "Bad credentials"));
                }
            }
        }




    }

