package org.yunchen.gb.plugin.springsecurity.userdetails

/**
 * Created by @Author:xiaopeng on 2017/6/11.
 */

    import org.springframework.security.core.GrantedAuthority
    import org.springframework.security.core.userdetails.User

    import groovy.transform.CompileStatic

/**
 * Extends the default Spring Security user class to contain the ID for efficient lookup
 * of the domain class from the Authentication.
 *
 *
 */
    @CompileStatic
    class CoreUser extends User {

        private static final long serialVersionUID = 1

        final id

        /**
         * Constructor.
         *
         * @param username the username presented to the
         *        <code>DaoAuthenticationProvider</code>
         * @param password the password that should be presented to the
         *        <code>DaoAuthenticationProvider</code>
         * @param enabled set to <code>true</code> if the user is enabled
         * @param accountNonExpired set to <code>true</code> if the account has not expired
         * @param credentialsNonExpired set to <code>true</code> if the credentials have not expired
         * @param accountNonLocked set to <code>true</code> if the account is not locked
         * @param authorities the authorities that should be granted to the caller if they
         *        presented the correct username and password and the user is enabled. Not null.
         * @param id the id of the domain class instance used to populate this
         */
        CoreUser(String username, String password, boolean enabled, boolean accountNonExpired,
                   boolean credentialsNonExpired, boolean accountNonLocked,
                   Collection<GrantedAuthority> authorities, id) {
            super(username, password, enabled, accountNonExpired, credentialsNonExpired,
                    accountNonLocked, authorities)
            this.id = id
        }
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            //sb.append(super.toString()).append(": ");
            sb.append("Username: ").append(this.username).append("; ");
            sb.append("Password: [PROTECTED]; ");
            sb.append("Enabled: ").append(this.enabled).append("; ");
            sb.append("AccountNonExpired: ").append(this.accountNonExpired).append("; ");
            sb.append("credentialsNonExpired: ").append(this.credentialsNonExpired).append("; ");
            sb.append("AccountNonLocked: ").append(this.accountNonLocked).append("; ");

            if (!authorities.isEmpty()) {
                sb.append("Granted Authorities: ");

                boolean first = true;
                for (GrantedAuthority auth : authorities) {
                    if (!first) {
                        sb.append(",");
                    }
                    first = false;

                    sb.append(auth);
                }
            }
            else {
                sb.append("Not granted any authorities");
            }

            return sb.toString();
        }
    }
