package org.yunchen.gb.plugin.springsecurity.userdetails


    import org.springframework.dao.DataAccessException
    import org.springframework.security.core.userdetails.UserDetails
    import org.springframework.security.core.userdetails.UserDetailsService
    import org.springframework.security.core.userdetails.UsernameNotFoundException

/**
 * Extension of the standard interface that allows specifying whether or not to load roles
 * from the database, e.g. for LDAP where role information is inferred from LDAP group membership.
 *
 * @author <a href='mailto:burt@burtbeckwith.com'>Burt Beckwith</a>
 */
    interface CoreUserDetailsService extends UserDetailsService {

        /**
         * Locates the user based on the username.
         *
         * @param username the username identifying the user whose data is required.
         * @param loadRoles whether to load roles at the same time as loading the user
         *
         * @return a fully populated user record (never <code>null</code>)
         *
         * @throws UsernameNotFoundException if the user could not be found
         * @throws DataAccessException if user could not be found for a repository-specific reason
         */
        UserDetails loadUserByUsername(String username, boolean loadRoles) throws UsernameNotFoundException, DataAccessException
    }
