package org.yunchen.gb.plugin.springsecurity.userdetails

import groovy.transform.CompileStatic
import org.springframework.context.support.MessageSourceAccessor
import org.springframework.security.authentication.CredentialsExpiredException
import org.springframework.security.core.SpringSecurityMessageSource
import org.springframework.security.core.userdetails.UserDetails
import org.springframework.security.core.userdetails.UserDetailsChecker

/**
 * Copy of the private class in AbstractUserDetailsAuthenticationProvider
 * to make subclassing or replacement easier.
 *
 *
 */
@CompileStatic
class DefaultPostAuthenticationChecks implements UserDetailsChecker {

    protected MessageSourceAccessor messages = SpringSecurityMessageSource.accessor

    void check(UserDetails user) {
        if (!user.credentialsNonExpired) {
            throw new CredentialsExpiredException(messages.getMessage(
                    'AbstractUserDetailsAuthenticationProvider.credentialsExpired',
                    'User credentials have expired'))
        }
    }
}
