package org.yunchen.gb.plugin.springsecurity.userdetails

import groovy.transform.CompileStatic
import org.springframework.context.support.MessageSourceAccessor
import org.springframework.security.authentication.AccountExpiredException
import org.springframework.security.authentication.DisabledException
import org.springframework.security.authentication.LockedException
import org.springframework.security.core.SpringSecurityMessageSource
import org.springframework.security.core.userdetails.UserDetails
import org.springframework.security.core.userdetails.UserDetailsChecker

/**
 * Created by @Author:xiaopeng on 2017/6/11.
 */

@CompileStatic
class DefaultPreAuthenticationChecks implements UserDetailsChecker {

    protected MessageSourceAccessor messages = SpringSecurityMessageSource.accessor

    void check(UserDetails user) {
        if (!user.accountNonLocked) {

            throw new LockedException(messages.getMessage('AbstractUserDetailsAuthenticationProvider.locked',
                    'User account is locked'))
        }

        if (!user.enabled) {

            throw new DisabledException(messages.getMessage('AbstractUserDetailsAuthenticationProvider.disabled',
                    'User is disabled'))
        }

        if (!user.accountNonExpired) {

            throw new AccountExpiredException(messages.getMessage('AbstractUserDetailsAuthenticationProvider.expired',
                    'User account has expired'))
        }
    }
}
