package org.yunchen.gb.plugin.springsecurity.userdetails

import org.springframework.util.ClassUtils
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.core.annotation.GbBootstrap
import org.yunchen.gb.plugin.springsecurity.config.SpringSecurityConfigurationProperties
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.context.annotation.Configuration
import org.springframework.security.core.GrantedAuthority
import org.springframework.security.core.authority.SimpleGrantedAuthority
import org.springframework.security.core.userdetails.UserDetails
import org.springframework.security.core.userdetails.UsernameNotFoundException

import org.yunchen.gb.plugin.springsecurity.GbSpringSecurityService
import org.yunchen.gb.plugin.springsecurity.GbSpringSecurityUtils
import org.yunchen.gb.plugin.springsecurity.GlobalAuthority

/**
 * Created by @Author:xiaopeng on 2017/6/11.
 *
 * 默认使用domain类加载用户和角色数据
 * 2019-08-08 在 3.6.0 版本中增加GlobalAuthority类处理用户及角色数据,
 * 从而可以配合微服务部署,不用创建用户角色domain类
 */
@Configuration
@EnableConfigurationProperties([SpringSecurityConfigurationProperties.class])
class GbUserDetailsService implements CoreUserDetailsService {
        @Autowired
        private SpringSecurityConfigurationProperties securityproperties;
        @Autowired
        GbSpringSecurityService gbSpringSecurityService

        /**
         * Some Spring Security classes (e.g. RoleHierarchyVoter) expect at least one role, so
         * we give a user with no granted roles this one which gets past that restriction but
         * doesn't grant anything.
         */
        static final GrantedAuthority NO_ROLE = new SimpleGrantedAuthority(GbSpringSecurityUtils.NO_ROLE)

        /** Dependency injection for the application. */
        //GrailsApplication grailsApplication

        //@Transactional(readOnly=true, noRollbackFor=[IllegalArgumentException, UsernameNotFoundException])
        UserDetails loadUserByUsername(String username, boolean loadRoles) throws UsernameNotFoundException {
            if(securityproperties.authorityWithoutDB){
                Map user= GlobalAuthority.userMaps[username]
                if(user){
                    Collection<GrantedAuthority> authorities=loadAuthorities(user, username, loadRoles)
                    return createUserDetails(user, authorities)
                }
                //log.warn 'User not found: {}', username
                throw new NoStackUsernameNotFoundException()
                //return null;
            }
            //def startup =  GbSpringUtils.getBean("startup");
            def startups = GbSpringUtils.applicationContext.getBeansWithAnnotation(GbBootstrap);
            if(startups && startups.size()>0 && GbSpringUtils.getConfiginfo('gb.cas.active')?.trim()=='true'){
                startups.each {k,v->
                    Class clazz=v?.class
                    if(ClassUtils.isCglibProxyClass(clazz)){
                        clazz=ClassUtils.getUserClass(clazz)
                    }
                    if(clazz.methods.name.contains("onCasChangeUsernameBeforeAuthentication")){
                        try{
                            username=v.onCasChangeUsernameBeforeAuthentication(username);
                        }catch (e){
                            e.printStackTrace();
                        }
                    }
                }
            }
            //@todo 遭遇到response after commit错误，以后改到filter中处理
/*            if(GbSpringUtils.getConfiginfo("gb.springsecurity.auth.alreadyLogin")){
                println "in alreadyLogin check in"
                if(gbSpringSecurityService.isLoggedIn()){
                    HttpServletResponse response=((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                    HttpServletRequest request=((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                    String url=request.contextPath+GbSpringUtils.getConfiginfo("gb.springsecurity.auth.alreadyLogin");
                    //response.sendRedirect(url);//遭遇到response after commit错误
                    request.getRequestDispatcher(url).forward(request,response);
                    return ;
                }
            }*/
            def conf = GbSpringSecurityUtils.securityConfig
            String userClassName = GbSpringUtils.getConfiginfo("gb.springsecurity.userLookup.userDomainClassName");
            def dc = GbSpringUtils.getDomain(userClassName)
            if (!dc) {
                throw new IllegalArgumentException("The specified user domain class '$userClassName' is not a domain class")
            }

            //Class<?> User = dc.clazz
            Class<?> User = dc
            //添加判断用户名的外部逻辑
            //gb.springsecurity.password.useCustomLoadUser=true
            def user
            if(GbSpringUtils.getConfiginfo('gb.springsecurity.password.useCustomLoadUser')?.trim()?.equals('true')){
                String methodname="customLoadUser"
                if(startups && startups.size()>0){
                    startups.each {k,v->
                        if(v.class.methods.collect {it.name}.contains(methodname)){
                            try{
                                user=v."${methodname}"(username);
                            }catch(e1){
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            }else{
                user = User.createCriteria().get {
                    //删除大小写无关判断
                    eq("username", username)
                }
            }


            if (!user) {
                if(startups && startups.size()>0 && GbSpringUtils.getConfiginfo('gb.cas.active')?.trim()=='true'){
                    startups.each {k,v->
                        if(v.class.methods.name.contains("onCasNoStackUsernameNotFoundAfterAuthentication")){
                            try{
                                def oneUser=v.onCasNoStackUsernameNotFoundAfterAuthentication(username, loadRoles);
                                if(oneUser){
                                    user=oneUser;
                                }
                            }catch (e){
                                e.printStackTrace();
                            }
                        }
                    }

                }else{
                    //log.warn 'User not found: {}', username
                    throw new NoStackUsernameNotFoundException()
                }
            }
            Collection<GrantedAuthority> authorities
            User.withNewSession{
                authorities = loadAuthorities(user, username, loadRoles)
            }
            createUserDetails user, authorities
        }

        UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
            loadUserByUsername username, true
        }

        protected Collection<GrantedAuthority> loadAuthorities(user, String username, boolean loadRoles) {
            if (!loadRoles) {
                return []
            }

            def conf = GbSpringSecurityUtils.securityConfig

            String authoritiesPropertyName = "authorities"
            String authorityPropertyName = "authority"

            boolean useGroups = conf?.useRoleGroups
            String authorityGroupPropertyName = conf?.authority?.groupAuthorityNameField

            Collection<?> userAuthorities = user."$authoritiesPropertyName"
            def authorities

            if (useGroups) {
                if (authorityGroupPropertyName) {
                    authorities = userAuthorities.collect { it."$authorityGroupPropertyName" }.flatten().unique().collect { new SimpleGrantedAuthority(it."$authorityPropertyName") }
                }
                else {
                    //log.warn 'Attempted to use group authorities, but the authority name field for the group class has not been defined.'
                }
            }
            else {
                authorities = userAuthorities.collect { new SimpleGrantedAuthority(it."$authorityPropertyName") }
            }
            authorities ?: [NO_ROLE]
        }

        protected UserDetails createUserDetails(user, Collection<GrantedAuthority> authorities) {

            def conf = GbSpringSecurityUtils.securityConfig

            String usernamePropertyName = "username"
            String passwordPropertyName = "password"
            String enabledPropertyName = "enabled"
            String accountExpiredPropertyName = "accountExpired"
            String accountLockedPropertyName = "accountLocked"
            String passwordExpiredPropertyName = "passwordExpired"

            String username = user."$usernamePropertyName"
            String password = user."$passwordPropertyName"
            boolean enabled = enabledPropertyName ? user."$enabledPropertyName" : true
            boolean accountExpired = accountExpiredPropertyName ? user."$accountExpiredPropertyName" : false
            boolean accountLocked = accountLockedPropertyName ? user."$accountLockedPropertyName" : false
            boolean passwordExpired = passwordExpiredPropertyName ? user."$passwordExpiredPropertyName" : false

            new CoreUser(username, password, enabled, !accountExpired, !passwordExpired, !accountLocked, authorities, user.id)
        }
}
