package org.yunchen.gb.plugin.springsecurity.userdetails

/**
 * Created by @Author:xiaopeng on 2017/6/11.
 */
import org.springframework.security.core.userdetails.UsernameNotFoundException
import groovy.transform.CompileStatic

/**
 * Lightweight exception that avoids the cost of filling in the stack frames.
 *
 *
 */
@CompileStatic
class NoStackUsernameNotFoundException extends UsernameNotFoundException {
    private static final long serialVersionUID = 1

    NoStackUsernameNotFoundException() {
        super('User not found')
    }

    @Override
    synchronized Throwable fillInStackTrace() {
        // do nothing
        return this
    }
}
