/* Copyright 2015-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.yunchen.gb.plugin.springsecurity.web

import groovy.transform.CompileStatic
import groovy.util.logging.Slf4j
import org.springframework.security.web.SecurityFilterChain
import org.springframework.security.web.util.matcher.AntPathRequestMatcher
import org.springframework.security.web.util.matcher.RequestMatcher

import javax.servlet.Filter
import javax.servlet.http.HttpServletRequest

/**
 * Based on org.springframework.security.web.DefaultSecurityFilterChain which is final.
 *
 * @author <a href='mailto:burt@burtbeckwith.com'>Burt Beckwith</a>
 */
@CompileStatic
@Slf4j
class GbSecurityFilterChain implements SecurityFilterChain {

	final RequestMatcher requestMatcher
	final List<Filter> filters
	final String matcherPattern

    GbSecurityFilterChain(String matcherPattern, List<Filter> filters) {
		this.filters = [] + filters
		this.matcherPattern = matcherPattern
		requestMatcher = new AntPathRequestMatcher(matcherPattern, null, false)
		log.info 'Creating filter chain: {}, {}', requestMatcher, filters
	}

	boolean matches(HttpServletRequest request) {
		requestMatcher.matches request
	}

	String toString() {
		"[$requestMatcher, $filters]"
	}
}
