/* Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.yunchen.gb.plugin.springsecurity.web


import groovy.transform.CompileStatic

import org.springframework.security.web.AuthenticationEntryPoint
import org.springframework.security.web.access.ExceptionTranslationFilter
import org.springframework.security.web.savedrequest.RequestCache
import org.springframework.web.context.request.RequestAttributes
import org.springframework.web.context.request.RequestContextHolder

import javax.servlet.FilterChain
import javax.servlet.ServletException
import javax.servlet.ServletRequest
import javax.servlet.ServletResponse
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

/**
 * Replaces the current GrailsWebRequest with one that delegates to the real current instance but uses the request and
 * response from the filter chain instead of the cached instances from earlier in the chain to ensure that controllers
 * and other classes that access the request from the thread-local RequestContextHolder use the correct instances.
 *
 * @author <a href='mailto:burt@burtbeckwith.com'>Burt Beckwith</a>
 */
@CompileStatic
class UpdateRequestContextHolderExceptionTranslationFilter extends ExceptionTranslationFilter {

	UpdateRequestContextHolderExceptionTranslationFilter(AuthenticationEntryPoint authenticationEntryPoint) {
		super(authenticationEntryPoint)
	}

	UpdateRequestContextHolderExceptionTranslationFilter(AuthenticationEntryPoint authenticationEntryPoint, RequestCache requestCache) {
		super(authenticationEntryPoint, requestCache)
	}

	void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest) req;
		HttpServletResponse response = (HttpServletResponse) res;

		RequestAttributes current = (RequestAttributes)RequestContextHolder.requestAttributes
		if (current) {
			RequestContextHolder.setRequestAttributes(current);
		}

/*		GrailsWebRequest current = (GrailsWebRequest)RequestContextHolder.requestAttributes
		if (current && !(current instanceof DelegatingGrailsWebRequest)) {
			WebUtils.storeGrailsWebRequest new DelegatingGrailsWebRequest(request, response, current)
		}*/

		super.doFilter request, response, chain
	}
}

/*
@CompileStatic
class DelegatingGrailsWebRequest extends GrailsWebRequest {

	@Delegate
	GrailsWebRequest current

	DelegatingGrailsWebRequest(HttpServletRequest request, HttpServletResponse response, GrailsWebRequest current) {
		super(request, response, current.attributes)
	}
}
*/

