package org.yunchen.gb.plugin.springsecurity.web.access.expression

import org.springframework.expression.Expression
import org.springframework.security.access.ConfigAttribute

import groovy.transform.CompileStatic

/**
 * Simple expression configuration attribute for use in web request authorizations.
 * Based on the class of the same name in Spring Security which is package-default.
 *
 * @author Luke Taylor
 * @author <a href='mailto:burt@burtbeckwith.com'>Burt Beckwith</a>
 */
@CompileStatic
class WebExpressionConfigAttribute implements ConfigAttribute {

    private static final long serialVersionUID = 1

    final Expression authorizeExpression

    /**
     * Constructor.
     * @param authorizeExpression the expression
     */
    WebExpressionConfigAttribute(Expression authorizeExpression) {
        this.authorizeExpression = authorizeExpression
    }

    String getAttribute() {}

    @Override
    String toString() {
        authorizeExpression.expressionString
    }
}
