/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.example.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.domain.Metadata;
import org.zalando.fahrschein.example.domain.OrderEvent;
import org.zalando.fahrschein.example.domain.OrderEventProcessor;

@JsonTypeName(value="eventlog.e96001_order_created")
public class OrderCreatedEvent
extends OrderEvent {
    private static final Logger LOG = LoggerFactory.getLogger(OrderCreatedEvent.class);
    private final Metadata metadata;
    private final String orderNumber;
    private final String customerNumber;
    private final Integer grandTotal;
    private final String paymentMethod;

    @JsonCreator
    public OrderCreatedEvent(@JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="orderNumber") String orderNumber, @JsonProperty(value="grandTotal") Integer grandTotal, @JsonProperty(value="customerNumber") String customerNumber, @JsonProperty(value="paymentMethod") String paymentMethod) {
        this.metadata = metadata;
        this.orderNumber = orderNumber;
        this.grandTotal = grandTotal;
        this.customerNumber = customerNumber;
        this.paymentMethod = paymentMethod;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getOrderNumber() {
        return this.orderNumber;
    }

    @Override
    public void process(OrderEventProcessor processor) {
        processor.processOrderCreated(this);
    }

    public Integer getGrandTotal() {
        return this.grandTotal;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }
}

