/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.example.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.domain.Metadata;
import org.zalando.fahrschein.example.domain.OrderEvent;
import org.zalando.fahrschein.example.domain.OrderEventProcessor;

@JsonTypeName(value="eventlog.e62001_order_payment_status_accepted")
public class OrderPaymentAcceptedEvent
extends OrderEvent {
    private static final Logger LOG = LoggerFactory.getLogger(OrderPaymentAcceptedEvent.class);
    private final Metadata metadata;
    private final String orderNumber;
    private final String paymentMethod;

    @JsonCreator
    public OrderPaymentAcceptedEvent(@JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="orderNumber") String orderNumber, @JsonProperty(value="paymentMethod") String paymentMethod) {
        this.metadata = metadata;
        this.orderNumber = orderNumber;
        this.paymentMethod = paymentMethod;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getOrderNumber() {
        return this.orderNumber;
    }

    @Override
    public void process(OrderEventProcessor processor) {
        processor.processPaymentAccepted(this);
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }
}

