/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.EventPublishingHandler;

public class InstrumentedPublishingHandler
implements EventPublishingHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InstrumentedPublishingHandler.class);
    private final Tracer tracer;

    public InstrumentedPublishingHandler(Tracer tracer) {
        this.tracer = tracer;
    }

    public <T> void onPublish(String eventName, List<T> events) {
        try {
            Span span = this.tracer.spanBuilder("send_" + eventName).setParent(Context.current()).setSpanKind(SpanKind.PRODUCER).setAttribute("messaging.destination_kind", "topic").setAttribute("messaging.destination", eventName).setAttribute("messaging.system", "Nakadi").setAttribute("messaging.message_payload_size", this.sizeBucket(events.size())).startSpan();
            span.makeCurrent();
        }
        catch (Exception e) {
            LOG.error("Exception during onPublish handling", (Throwable)e);
        }
    }

    public void afterPublish() {
        try {
            Span.current().end();
        }
        catch (Exception e) {
            LOG.error("Exception during afterPublish handling", (Throwable)e);
        }
    }

    public <T> void onError(List<T> events, Throwable t) {
        try {
            Span.current().setStatus(StatusCode.ERROR).recordException(t);
        }
        catch (Exception e) {
            LOG.error("Exception during onError handling", (Throwable)e);
        }
    }

    String sizeBucket(int size) {
        if (size == 0) {
            return "0";
        }
        return String.format(Locale.ENGLISH, "%.0f-%.0f", Math.floor((float)(size - 1) / 10.0f) * 10.0 + 1.0, Math.ceil((float)size / 10.0f) * 10.0);
    }
}

