/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.HashMap;
import java.util.Map;
import org.zalando.fahrschein.domain.Metadata;

public class OpenTelemetryHelper {
    private OpenTelemetryHelper() {
    }

    public static Context extractFromMetadata(Metadata metadata) {
        Map carrier = metadata.getSpanCtx();
        if (carrier == null || carrier.isEmpty()) {
            return Context.current();
        }
        OpenTelemetry ot = GlobalOpenTelemetry.get();
        TextMapPropagator propagator = ot.getPropagators().getTextMapPropagator();
        return propagator.extract(Context.current(), (Object)carrier, (TextMapGetter)new TextMapGetter<Map<String, String>>(){

            public String get(Map<String, String> carrier, String key) {
                return carrier.get(key);
            }

            public Iterable<String> keys(Map<String, String> carrier) {
                return carrier.keySet();
            }
        });
    }

    public static Map<String, String> currentContextToMap() {
        HashMap<String, String> carrier = new HashMap<String, String>();
        OpenTelemetry ot = GlobalOpenTelemetry.get();
        TextMapPropagator propagator = ot.getPropagators().getTextMapPropagator();
        propagator.inject(Context.current(), carrier, (carrier1, key, value) -> carrier1.put(key, value));
        return carrier;
    }
}

