/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.function.Consumer;
import java.util.function.Function;
import org.zalando.fahrschein.domain.Event;
import org.zalando.fahrschein.opentelemetry.OpenTelemetryHelper;

public class OpenTelemetryWrapper {
    private Tracer tracer;
    private String operationName;

    public OpenTelemetryWrapper(Tracer tracer, String operationName) {
        this.tracer = tracer;
        this.operationName = operationName;
    }

    public <R, T extends Event> R process(T event, Function<T, R> f) {
        Context context = OpenTelemetryHelper.extractFromMetadata(event.getMetadata());
        Span span = this.tracer.spanBuilder(this.operationName).setParent(context).setSpanKind(SpanKind.CONSUMER).startSpan();
        try {
            R r;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    r = f.apply(event);
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return r;
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Event> void process(T event, Consumer<T> c) {
        Context context = OpenTelemetryHelper.extractFromMetadata(event.getMetadata());
        Span span = this.tracer.spanBuilder(this.operationName).setParent(context).setSpanKind(SpanKind.CONSUMER).startSpan();
        try (Scope scope = span.makeCurrent();){
            c.accept(event);
        }
        finally {
            span.end();
        }
    }
}

