/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.kontrolletti;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;
import org.zalando.kontrolletti.AbstractPageRequest;
import org.zalando.kontrolletti.CommitRangeRequest;
import org.zalando.kontrolletti.KontrollettiOperations;
import org.zalando.kontrolletti.ListCommitsResponse;
import org.zalando.kontrolletti.ListTicketsResponse;
import org.zalando.kontrolletti.resources.Commit;
import org.zalando.kontrolletti.resources.Repository;
import org.zalando.kontrolletti.resources.Ticket;

public class RestTemplateKontrollettiOperations
implements KontrollettiOperations {
    static final String X_NORMALIZED_REPOSITORY_URL = "X-Normalized-Repository-URL";
    private static final String UTF_8 = "UTF-8";
    private final RestOperations restOperations;
    private final String baseUrl;
    private final ObjectMapper om = new ObjectMapper();

    public RestTemplateKontrollettiOperations(RestOperations restOperations, String baseUrl) {
        this.restOperations = restOperations;
        this.baseUrl = baseUrl;
    }

    public String normalizeRepositoryUrl(String repositoryUrl) {
        ResponseEntity response;
        Assert.hasText((String)repositoryUrl, (String)"repositoryUrl must not be blank");
        URI uri = this.buildUri("api", "repos", repositoryUrl);
        try {
            response = this.restOperations.exchange(RequestEntity.head((URI)uri).build(), Object.class);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return repositoryUrl;
            }
            throw e;
        }
        HttpStatus statusCode = response.getStatusCode();
        if (statusCode.is2xxSuccessful() || statusCode.is3xxRedirection()) {
            HttpHeaders headers = response.getHeaders();
            Assert.state((boolean)headers.containsKey((Object)X_NORMALIZED_REPOSITORY_URL), (String)"response headers did not contain X-Normalized-Repository-URL");
            try {
                return URLDecoder.decode(headers.getFirst(X_NORMALIZED_REPOSITORY_URL), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Unexpected response: " + response);
    }

    public Repository getRepository(String repositoryUrl) {
        if (repositoryUrl == null || repositoryUrl.isEmpty()) {
            throw new IllegalArgumentException("repositoryUrl must not be null");
        }
        URI uri = this.buildUri("api", "repos", repositoryUrl);
        try {
            return (Repository)this.restOperations.getForObject(uri, Repository.class);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw e;
        }
    }

    public ListCommitsResponse listCommits(CommitRangeRequest request) {
        URI uri = this.buildUri(RestTemplateKontrollettiOperations.path("api", "hosts", request.getHost(), "projects", request.getProject(), "repos", request.getRepository(), "commits"), this.getQueryParams(request));
        try {
            ResponseEntity response = this.restOperations.getForEntity(uri, JsonNode.class);
            List commits = this.getJsonResult((JsonNode)response.getBody(), Commit[].class).map(Arrays::asList).orElseGet(Collections::emptyList);
            return new ListCommitsResponse(request, this.totalPages(response, (AbstractPageRequest)request), commits);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return new ListCommitsResponse(request, 0, Collections.emptyList());
            }
            throw e;
        }
    }

    public Commit getCommit(String host, String project, String repository, String id) {
        Assert.hasText((String)host, (String)"host must not be blank");
        Assert.hasText((String)project, (String)"project must not be blank");
        Assert.hasText((String)repository, (String)"repository must not be blank");
        Assert.hasText((String)id, (String)"id must not be blank");
        URI uri = this.buildUri("api", "hosts", host, "projects", project, "repos", repository, "commits", id);
        return this.getJsonResult((JsonNode)this.restOperations.getForObject(uri, JsonNode.class), Commit.class).orElse(null);
    }

    public ListTicketsResponse listTickets(CommitRangeRequest request) {
        URI uri = this.buildUri(RestTemplateKontrollettiOperations.path("api", "hosts", request.getHost(), "projects", request.getProject(), "repos", request.getRepository(), "tickets"), this.getQueryParams(request));
        ResponseEntity response = this.restOperations.getForEntity(uri, JsonNode.class);
        List tickets = this.getJsonResult((JsonNode)response.getBody(), Ticket[].class).map(Arrays::asList).orElseGet(Collections::emptyList);
        return new ListTicketsResponse(request, this.totalPages(response, (AbstractPageRequest)request), tickets);
    }

    private int totalPages(ResponseEntity<?> response, AbstractPageRequest request) {
        int pageSize = request.getPerPage();
        int totalItems = Optional.of(response).map(HttpEntity::getHeaders).map(headers -> headers.getFirst("X-Total-Count")).map(Integer::valueOf).orElse(0);
        return (totalItems + pageSize - 1) / pageSize;
    }

    private MultiValueMap<String, String> getQueryParams(CommitRangeRequest request) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.add((Object)"page", (Object)String.valueOf(request.getPage()));
        queryParams.add((Object)"per_page", (Object)String.valueOf(request.getPerPage()));
        this.addIfPresent((MultiValueMap<String, String>)queryParams, request.getFromDate(), "from_date");
        this.addIfPresent((MultiValueMap<String, String>)queryParams, request.getToDate(), "to_date");
        this.addIfPresent((MultiValueMap<String, String>)queryParams, request.getIsValid(), "is_valid");
        return queryParams;
    }

    private void addIfPresent(MultiValueMap<String, String> params, Optional<?> param, String name) {
        param.ifPresent(value -> params.add((Object)name, (Object)String.valueOf(value)));
    }

    private <T> Optional<T> getJsonResult(JsonNode json, Class<T> targetClass) {
        return Optional.ofNullable(json).map(node -> node.get("result")).map(jsonNode -> {
            try {
                return this.om.readerFor(targetClass).readValue(jsonNode);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read json response as " + targetClass.getSimpleName(), e);
            }
        });
    }

    private URI buildUri(String ... pathSegments) {
        return this.buildUri(RestTemplateKontrollettiOperations.path(pathSegments), null);
    }

    private URI buildUri(List<String> pathSegments, MultiValueMap<String, String> queryParams) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.baseUrl);
        if (pathSegments != null && pathSegments.size() > 0) {
            pathSegments.stream().map(RestTemplateKontrollettiOperations::urlEncode).forEach(xva$0 -> builder.pathSegment(new String[]{xva$0}));
        }
        if (queryParams != null && queryParams.size() > 0) {
            queryParams.replaceAll((key, value) -> RestTemplateKontrollettiOperations.urlEncode(value));
            builder.queryParams(queryParams);
        }
        return builder.build(true).toUri();
    }

    private static List<String> path(String ... pathSegments) {
        return Arrays.asList(pathSegments);
    }

    private static List<String> urlEncode(List<String> strings) {
        return strings.stream().map(RestTemplateKontrollettiOperations::urlEncode).collect(Collectors.toList());
    }

    private static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

