/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.idempotency;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.idempotency.IdempotencyDetector;

@API(status=API.Status.EXPERIMENTAL)
public final class ConditionalIdempotencyDetector
implements IdempotencyDetector {
    private final Map<String, Predicate<String>> conditionals = ImmutableMap.of((Object)"If-Match", arg_0 -> ((CharMatcher)CharMatcher.anyOf((CharSequence)"*,")).matchesNoneOf(arg_0), (Object)"If-None-Match", "*"::equals, (Object)"If-Unmodified-Since", $ -> true);

    @Override
    public boolean test(RequestArguments arguments, Predicate<RequestArguments> root) {
        Map headers = arguments.getHeaders();
        return this.conditionals.entrySet().stream().anyMatch(entry -> {
            String name = (String)entry.getKey();
            Predicate predicate = (Predicate)entry.getValue();
            List values = headers.getOrDefault(name, Collections.emptyList());
            return values.stream().anyMatch(predicate);
        });
    }
}

