/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.idempotency;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.zalando.riptide.Attribute;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.idempotency.ConditionalIdempotencyDetector;
import org.zalando.riptide.idempotency.DefaultIdempotencyDetector;
import org.zalando.riptide.idempotency.IdempotencyDetector;
import org.zalando.riptide.idempotency.IdempotencyKeyIdempotencyDetector;
import org.zalando.riptide.idempotency.MethodOverrideIdempotencyDetector;

@API(status=API.Status.EXPERIMENTAL)
public final class IdempotencyPredicate
implements Predicate<RequestArguments> {
    public static final Attribute<Boolean> IDEMPOTENT = Attribute.generate();
    private final Collection<IdempotencyDetector> detectors;

    public IdempotencyPredicate() {
        this(Arrays.asList(new DefaultIdempotencyDetector(), new ConditionalIdempotencyDetector(), new IdempotencyKeyIdempotencyDetector(), new MethodOverrideIdempotencyDetector()));
    }

    @Override
    public boolean test(RequestArguments arguments) {
        return arguments.getAttribute(IDEMPOTENT).orElseGet(() -> this.detectors.stream().anyMatch(detector -> detector.test(arguments, modified -> !arguments.equals(modified) && this.test((RequestArguments)modified))));
    }

    public IdempotencyPredicate(Collection<IdempotencyDetector> detectors) {
        this.detectors = detectors;
    }
}

