/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.idempotency;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.idempotency.IdempotencyDetector;

@API(status=API.Status.EXPERIMENTAL)
public final class MethodOverrideIdempotencyDetector
implements IdempotencyDetector {
    private static final Logger log = LoggerFactory.getLogger(MethodOverrideIdempotencyDetector.class);

    @Override
    public boolean test(RequestArguments arguments, Predicate<RequestArguments> root) {
        if (arguments.getMethod() != HttpMethod.POST) {
            return false;
        }
        HttpMethod method = this.getOverride(arguments);
        if (method == null) {
            return false;
        }
        return root.test(arguments.withMethod(method));
    }

    @Nullable
    private HttpMethod getOverride(RequestArguments arguments) {
        Map headers = arguments.getHeaders();
        String name = "X-HTTP-Method-Override";
        Collection overrides = headers.getOrDefault("X-HTTP-Method-Override", Collections.emptyList());
        String override = overrides.stream().findFirst().orElse(null);
        if (override == null) {
            return null;
        }
        try {
            return HttpMethod.valueOf((String)override);
        }
        catch (IllegalArgumentException e) {
            log.warn("Received invalid method in {} header: \"{}\"", (Object)"X-HTTP-Method-Override", (Object)override);
            return null;
        }
    }
}

