/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.idempotency;

import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.idempotency.ConditionalIdempotencyDetector;
import org.zalando.riptide.idempotency.Decision;
import org.zalando.riptide.idempotency.DefaultIdempotencyDetector;
import org.zalando.riptide.idempotency.ExplicitIdempotencyDetector;
import org.zalando.riptide.idempotency.IdempotencyDetector;
import org.zalando.riptide.idempotency.IdempotencyKeyIdempotencyDetector;
import org.zalando.riptide.idempotency.MethodOverrideIdempotencyDetector;

@API(status=API.Status.EXPERIMENTAL)
public final class IdempotencyPredicate
implements Predicate<RequestArguments> {
    private final Collection<IdempotencyDetector> detectors;

    public IdempotencyPredicate() {
        this(Arrays.asList(new ConditionalIdempotencyDetector(), new DefaultIdempotencyDetector(), new ExplicitIdempotencyDetector(), new IdempotencyKeyIdempotencyDetector(), new MethodOverrideIdempotencyDetector()));
    }

    @Override
    public boolean test(RequestArguments arguments) {
        return this.decide(arguments) == Decision.ACCEPT;
    }

    private Decision decide(RequestArguments arguments) {
        IdempotencyDetector.Test test = modified -> arguments.equals(modified) ? Decision.NEUTRAL : this.decide(modified);
        Decision decision = Decision.NEUTRAL;
        for (IdempotencyDetector detector : this.detectors) {
            Decision current = detector.test(arguments, test);
            if ((decision = this.max(decision, current)) != Decision.DENY) continue;
            return decision;
        }
        return decision;
    }

    private Decision max(Decision left, Decision right) {
        return (Decision)((Object)Ordering.natural().max((Object)left, (Object)right));
    }

    @Generated
    public IdempotencyPredicate(Collection<IdempotencyDetector> detectors) {
        this.detectors = detectors;
    }
}

