/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.spring.cloud.config.aws.kms;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import de.zalando.spring.cloud.config.aws.kms.KmsProperties;
import de.zalando.spring.cloud.config.aws.kms.KmsTextEncryptor;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.TextEncryptor;

@Configuration
@ConditionalOnProperty(prefix="aws.kms", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={KmsProperties.class})
class KmsEncryptionConfiguration {
    private final KmsTextEncryptor kmsTextEncryptor;

    @Autowired
    public KmsEncryptionConfiguration(KmsTextEncryptor kmsTextEncryptor) {
        this.kmsTextEncryptor = kmsTextEncryptor;
    }

    @Bean
    EnvironmentDecryptApplicationInitializer environmentDecryptApplicationInitializer() {
        return new EnvironmentDecryptApplicationInitializer((TextEncryptor)this.kmsTextEncryptor);
    }

    @Configuration
    @ConditionalOnMissingBean(value={AWSKMS.class})
    static class KmsConfiguration {
        private final KmsProperties properties;

        @Autowired
        public KmsConfiguration(KmsProperties properties) {
            this.properties = properties;
        }

        @Bean
        public AWSKMS kms() {
            AWSKMSClientBuilder builder = AWSKMSClient.builder();
            if (Optional.ofNullable(this.properties.getEndpoint()).isPresent()) {
                builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.properties.getEndpoint().getServiceEndpoint(), this.properties.getEndpoint().getSigningRegion()));
            } else {
                Optional.ofNullable(this.properties.getRegion()).ifPresent(arg_0 -> ((AWSKMSClientBuilder)builder).setRegion(arg_0));
            }
            return (AWSKMS)builder.build();
        }
    }

    @Configuration
    static class KmsTextEncryptorConfiguration {
        private final KmsProperties properties;
        private final AWSKMS kms;

        @Autowired
        public KmsTextEncryptorConfiguration(KmsProperties properties, AWSKMS kms) {
            this.properties = properties;
            this.kms = kms;
        }

        @Bean
        KmsTextEncryptor kmsTextEncryptor() {
            return new KmsTextEncryptor(this.kms, this.properties.getKeyId());
        }
    }
}

