/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.oauth2.httpcomponents;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.zalando.stups.tokens.AccessTokens;

public class AccessTokensRequestInterceptor
implements HttpRequestInterceptor {
    private final String tokenId;
    private final AccessTokens accessTokens;

    public AccessTokensRequestInterceptor(String tokenId, AccessTokens accessTokens) {
        Args.check((tokenId != null ? 1 : 0) != 0, (String)"'tokenId' should never be null");
        Args.check((accessTokens != null ? 1 : 0) != 0, (String)"'accessTokens' should never be null");
        Args.check((!tokenId.trim().isEmpty() ? 1 : 0) != 0, (String)"'tokenId' should never be empty");
        this.tokenId = tokenId;
        this.accessTokens = accessTokens;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        try {
            request.setHeader("access_token", this.accessTokens.get((Object)this.tokenId));
        }
        catch (Exception e) {
            throw new HttpException("Unable to place header 'access_token' into request.", (Throwable)e);
        }
    }
}

