/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.toga.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import de.zalando.toga.generator.dimensions.ObjectDimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class Generator {
    private ObjectDimension dimension;

    public void load(File file) {
        try {
            JsonNode node = JsonLoader.fromFile((File)file);
            JsonNode properties = node.get("properties");
            this.dimension = ObjectDimension.from(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generate(File file) {
        if (file == null) {
            throw new NullPointerException("Target File may not be null");
        }
        if (file.exists() && !file.delete()) {
            throw new IllegalStateException("Could not delete already existing output file [" + file.getAbsolutePath() + "].");
        }
        if (this.dimension == null) {
            throw new IllegalStateException("No JSON schema has been loaded. Cannot generate output.");
        }
        try {
            PrintWriter writer = new PrintWriter(file);
            ((Writer)writer).write("[\n  {}\n]");
            ((Writer)writer).flush();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File [" + file.getAbsolutePath() + "] does not exist.");
        }
        catch (IOException e) {
            throw new RuntimeException("There has been a problem with the output file.", e);
        }
    }
}

