/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.toga.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ExampleProvider {
    private final File sourceDir;
    @VisibleForTesting
    ObjectMapper mapper = new ObjectMapper();

    public ExampleProvider(File sourceDir) {
        if (sourceDir == null) {
            throw new IllegalArgumentException("sourceDir must not be null!");
        }
        if (!sourceDir.exists()) {
            throw new IllegalArgumentException("sourceDir [" + sourceDir.getAbsolutePath() + "] does not exist.");
        }
        if (sourceDir.isFile()) {
            throw new IllegalArgumentException("sourceDir [" + sourceDir.getAbsolutePath() + "] is a file.");
        }
        this.sourceDir = sourceDir;
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public List<String> getExamples(Pattern pattern) {
        List<File> sources = this.collectSources(pattern);
        ArrayList<String> results = new ArrayList<String>();
        for (File source : sources) {
            try {
                List nodes = (List)this.mapper.readValue(source, (TypeReference)new TypeReference<List<ObjectNode>>(){});
                List strings = nodes.stream().map(ObjectNode::toString).collect(Collectors.toList());
                results.addAll(strings);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    public List<String> getExamples(String pattern) {
        return this.getExamples(Pattern.compile(pattern));
    }

    private List<File> collectSources(Pattern pattern) {
        File[] files = this.sourceDir.listFiles((dir, name) -> {
            Matcher matcher = pattern.matcher(name);
            return matcher.find();
        });
        return new ArrayList<File>(Arrays.asList(files));
    }
}

