/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.toga.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.File;
import java.io.IOException;

public class SchemaValidator {
    private JsonSchema schema;

    public void loadSchema(File schemaLocation) {
        try {
            JsonNode schemaNode = JsonLoader.fromFile((File)schemaLocation);
            this.schema = JsonSchemaFactory.byDefault().getJsonSchema(schemaNode);
        }
        catch (ProcessingException | IOException e) {
            throw new RuntimeException("Error loading schema", e);
        }
    }

    public ProcessingReport validate(String input) {
        if (this.schema == null) {
            throw new IllegalStateException("Tried to validate without schema.");
        }
        try {
            JsonNode dataNode = JsonLoader.fromString((String)input);
            return this.schema.validate(dataNode);
        }
        catch (ProcessingException | IOException e) {
            throw new RuntimeException("Exception while validating.", e);
        }
    }
}

