/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.dto.resource;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.DTOUtil;
import org.zanata.rest.dto.resource.TextFlowTarget;

public class TextFlowTargetTest {
    ObjectMapper om = new ObjectMapper();
    LocaleId esES = new LocaleId("es-ES");

    @Test
    public void testReadJsonPlural() throws JsonParseException, JsonMappingException, IOException {
        String json = "{\n    \"id\" : \"_id\",\n    \"resId\" : \"_resid\",\n    \"revision\" : 17,\n    \"lang\" : \"es-ES\",\n    \"contents\" : [\"plural1\", \"plural2\"]\n}";
        TextFlowTarget tft = (TextFlowTarget)this.om.readValue(json, TextFlowTarget.class);
        TextFlowTarget expected = new TextFlowTarget("_id");
        expected.setResId("_resid");
        expected.setContents(new String[]{"plural1", "plural2"});
        expected.setRevision(Integer.valueOf(17));
        Assert.assertEquals((Object)tft, (Object)expected);
    }

    @Test
    public void testReadJsonSingular() throws JsonParseException, JsonMappingException, IOException {
        String json = "{\n    \"id\" : \"_id\",\n    \"resId\" : \"_resid\",\n    \"revision\" : 17,\n    \"lang\" : \"es-ES\",\n    \"content\" : \"single\"\n}";
        TextFlowTarget tft = (TextFlowTarget)this.om.readValue(json, TextFlowTarget.class);
        TextFlowTarget expected = new TextFlowTarget("_id");
        expected.setResId("_resid");
        expected.setContents(new String[]{"single"});
        expected.setRevision(Integer.valueOf(17));
        Assert.assertEquals((Object)tft, (Object)expected);
    }

    @Test
    public void testReadXmlPlural() throws JAXBException {
        String xml = "<TextFlowTarget revision=\"17\" xml:lang=\"es-ES\" id=\"_id\" res-id=\"_resid\" xmlns:ns2=\"http://zanata.org/namespace/api/gettext/\">\n    <contents>\n        <content>abc</content>\n        <content>def</content>\n    </contents>\n</TextFlowTarget>";
        TextFlowTarget tf = (TextFlowTarget)DTOUtil.toObject((String)xml, TextFlowTarget.class);
        TextFlowTarget expected = new TextFlowTarget("_id");
        expected.setResId("_resid");
        expected.setContents(new String[]{"abc", "def"});
        expected.setRevision(Integer.valueOf(17));
        Assert.assertEquals((Object)tf, (Object)expected);
    }

    @Test
    public void testReadXmlSingular() throws JAXBException {
        String xml = "<TextFlowTarget revision=\"17\" xml:lang=\"es-ES\" id=\"_id\" res-id=\"_resid\" xmlns:ns2=\"http://zanata.org/namespace/api/gettext/\">\n    <content>abc</content>\n</TextFlowTarget>";
        TextFlowTarget tft = (TextFlowTarget)DTOUtil.toObject((String)xml, TextFlowTarget.class);
        TextFlowTarget expected = new TextFlowTarget("_id");
        expected.setResId("_resid");
        expected.setContents(new String[]{"abc"});
        expected.setRevision(Integer.valueOf(17));
        Assert.assertEquals((Object)tft, (Object)expected);
    }

    @Test
    public void testWritePlural() throws JsonGenerationException, JsonMappingException, IOException {
        TextFlowTarget tft = new TextFlowTarget();
        tft.setContents(new String[]{"abc", "def"});
        String expectedXML = "<TextFlowTarget state=\"New\" xmlns:ns2=\"http://zanata.org/namespace/api/\">\n    <contents>\n        <content>abc</content>\n        <content>def</content>\n    </contents>\n</TextFlowTarget>";
        Assert.assertEquals((String)tft.toString(), (String)expectedXML);
        String expectedJSON = "{\"state\":\"New\",\"content\":\"\",\"contents\":[\"abc\",\"def\"]}";
        Assert.assertEquals((String)this.om.writeValueAsString((Object)tft), (String)expectedJSON);
    }

    @Test
    public void testWriteSingular() throws JsonGenerationException, JsonMappingException, IOException {
        TextFlowTarget tft = new TextFlowTarget();
        tft.setContents(new String[]{"abc"});
        String expectedXML = "<TextFlowTarget state=\"New\" xmlns:ns2=\"http://zanata.org/namespace/api/\">\n    <content>abc</content>\n</TextFlowTarget>";
        Assert.assertEquals((String)tft.toString(), (String)expectedXML);
        String expectedJSON = "{\"state\":\"New\",\"content\":\"abc\"}";
        Assert.assertEquals((String)this.om.writeValueAsString((Object)tft), (String)expectedJSON);
    }
}

