/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.dto.resource;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.DTOUtil;
import org.zanata.rest.dto.resource.TextFlow;

public class TextFlowTest {
    ObjectMapper om = new ObjectMapper();
    LocaleId esES = new LocaleId("es-ES");

    @Test
    public void testReadJsonPlural() throws JsonParseException, JsonMappingException, IOException {
        String json = "{\n    \"id\" : \"_id\",\n    \"revision\" : 17,\n    \"lang\" : \"es-ES\",\n    \"contents\" : [\"plural1\", \"plural2\"]\n}";
        TextFlow tf = (TextFlow)this.om.readValue(json, TextFlow.class);
        TextFlow expected = new TextFlow("_id", this.esES, new String[]{"plural1", "plural2"});
        expected.setRevision(Integer.valueOf(17));
        Assert.assertEquals((Object)tf, (Object)expected);
    }

    @Test
    public void testReadJsonSingular() throws JsonParseException, JsonMappingException, IOException {
        String json = "{\n    \"id\" : \"_id\",\n    \"revision\" : 17,\n    \"lang\" : \"es-ES\",\n    \"content\" : \"single\"\n}";
        TextFlow tf = (TextFlow)this.om.readValue(json, TextFlow.class);
        TextFlow expected = new TextFlow("_id", this.esES, new String[]{"single"});
        expected.setRevision(Integer.valueOf(17));
        Assert.assertEquals((Object)tf, (Object)expected);
    }

    @Test
    public void testReadXmlPlural() throws JAXBException {
        String xml = "<TextFlow revision=\"17\" xml:lang=\"es-ES\" id=\"_id\" xmlns:ns2=\"http://zanata.org/namespace/api/gettext/\">\n    <contents>\n        <content>abc</content>\n        <content>def</content>\n    </contents>\n</TextFlow>";
        TextFlow tf = (TextFlow)DTOUtil.toObject((String)xml, TextFlow.class);
        TextFlow expected = new TextFlow("_id", this.esES, new String[]{"abc", "def"});
        expected.setRevision(Integer.valueOf(17));
        Assert.assertEquals((Object)tf, (Object)expected);
    }

    @Test
    public void testReadXmlSingular() throws JAXBException {
        String xml = "<TextFlow revision=\"17\" xml:lang=\"es-ES\" id=\"_id\" xmlns:ns2=\"http://zanata.org/namespace/api/gettext/\">\n    <content>abc</content>\n</TextFlow>";
        TextFlow tf = (TextFlow)DTOUtil.toObject((String)xml, TextFlow.class);
        TextFlow expected = new TextFlow("_id", this.esES, new String[]{"abc"});
        expected.setRevision(Integer.valueOf(17));
        Assert.assertEquals((Object)tf, (Object)expected);
    }

    @Test
    public void testWriteSingular() throws JsonGenerationException, JsonMappingException, IOException {
        TextFlow tf = new TextFlow();
        tf.setContents(new String[]{"abc"});
        String expectedXML = "<TextFlow xmlns:ns2=\"http://zanata.org/namespace/api/gettext/\">\n    <content>abc</content>\n    <plural>false</plural>\n</TextFlow>";
        Assert.assertEquals((String)tf.toString(), (String)expectedXML);
        String expectedJSON = "{\"content\":\"abc\",\"plural\":false}";
        Assert.assertEquals((String)this.om.writeValueAsString((Object)tf), (String)expectedJSON);
    }

    @Test
    public void testWritePlural() throws JsonGenerationException, JsonMappingException, IOException {
        TextFlow tf = new TextFlow();
        tf.setContents(new String[]{"abc", "def"});
        tf.setPlural(true);
        String expectedXML = "<TextFlow xmlns:ns2=\"http://zanata.org/namespace/api/gettext/\">\n    <contents>\n        <content>abc</content>\n        <content>def</content>\n    </contents>\n    <plural>true</plural>\n</TextFlow>";
        Assert.assertEquals((String)tf.toString(), (String)expectedXML);
        String expectedJSON = "{\"content\":\"\",\"contents\":[\"abc\",\"def\"],\"plural\":true}";
        Assert.assertEquals((String)this.om.writeValueAsString((Object)tf), (String)expectedJSON);
    }
}

