/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.dto.stats;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;
import org.zanata.common.LocaleId;
import org.zanata.common.TransUnitCount;
import org.zanata.common.TransUnitWords;
import org.zanata.rest.dto.stats.TranslationStatistics;

@Test(groups={"unit-tests"})
public class TranslationStatisticsTest {
    TranslationStatistics stats;
    TransUnitCount unitCount;
    TransUnitWords wordCount;
    private LocaleId localeId = LocaleId.DE;

    @Test
    public void setGetUnitCount() {
        this.unitCount = new TransUnitCount(5, 5, 5);
        this.stats = new TranslationStatistics(this.unitCount, this.localeId.getId());
        MatcherAssert.assertThat((Object)this.stats.getLocale(), (Matcher)Matchers.equalTo((Object)this.localeId.getId()));
        MatcherAssert.assertThat((Object)this.stats.getUnit(), (Matcher)Matchers.equalTo((Object)TranslationStatistics.StatUnit.MESSAGE));
        MatcherAssert.assertThat((Object)((int)this.stats.getApproved()), (Matcher)Matchers.equalTo((Object)this.unitCount.getApproved()));
        MatcherAssert.assertThat((Object)((int)this.stats.getRejected()), (Matcher)Matchers.equalTo((Object)this.unitCount.getRejected()));
        MatcherAssert.assertThat((Object)((int)this.stats.getTotal()), (Matcher)Matchers.equalTo((Object)this.unitCount.getTotal()));
        MatcherAssert.assertThat((Object)((int)this.stats.getTranslated()), (Matcher)Matchers.equalTo((Object)(this.unitCount.getTranslated() + this.unitCount.getApproved())));
        MatcherAssert.assertThat((Object)((int)this.stats.getUntranslated()), (Matcher)Matchers.equalTo((Object)this.unitCount.getUntranslated()));
        MatcherAssert.assertThat((Object)((int)this.stats.getDraft()), (Matcher)Matchers.equalTo((Object)(this.unitCount.getNeedReview() + this.unitCount.getRejected())));
    }

    @Test
    public void setGetWordCount() {
        this.wordCount = new TransUnitWords(5, 5, 5);
        this.stats = new TranslationStatistics(this.wordCount, this.localeId.getId());
        MatcherAssert.assertThat((Object)this.stats.getLocale(), (Matcher)Matchers.equalTo((Object)this.localeId.getId()));
        MatcherAssert.assertThat((Object)this.stats.getUnit(), (Matcher)Matchers.equalTo((Object)TranslationStatistics.StatUnit.WORD));
        MatcherAssert.assertThat((Object)((int)this.stats.getApproved()), (Matcher)Matchers.equalTo((Object)this.wordCount.getApproved()));
        MatcherAssert.assertThat((Object)((int)this.stats.getRejected()), (Matcher)Matchers.equalTo((Object)this.wordCount.getRejected()));
        MatcherAssert.assertThat((Object)((int)this.stats.getTotal()), (Matcher)Matchers.equalTo((Object)this.wordCount.getTotal()));
        MatcherAssert.assertThat((Object)((int)this.stats.getTranslated()), (Matcher)Matchers.equalTo((Object)(this.wordCount.getTranslated() + this.wordCount.getApproved())));
        MatcherAssert.assertThat((Object)((int)this.stats.getUntranslated()), (Matcher)Matchers.equalTo((Object)this.wordCount.getUntranslated()));
        MatcherAssert.assertThat((Object)((int)this.stats.getDraft()), (Matcher)Matchers.equalTo((Object)(this.wordCount.getNeedReview() + this.wordCount.getRejected())));
    }

    @Test
    public void noArgConstructorSetsZeroStats() {
        this.stats = new TranslationStatistics();
        MatcherAssert.assertThat((Object)this.stats.getUnit(), (Matcher)Matchers.equalTo((Object)TranslationStatistics.StatUnit.MESSAGE));
        MatcherAssert.assertThat((Object)((int)this.stats.getApproved()), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)((int)this.stats.getDraft()), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)((int)this.stats.getUntranslated()), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void add() {
        this.stats = new TranslationStatistics();
        this.unitCount = new TransUnitCount(5, 5, 5);
        TranslationStatistics otherStats = new TranslationStatistics(this.unitCount, this.localeId.getId());
        this.stats.add(otherStats);
        MatcherAssert.assertThat((Object)((int)this.stats.getApproved()), (Matcher)Matchers.equalTo((Object)this.unitCount.getApproved()));
        MatcherAssert.assertThat((Object)((int)this.stats.getRejected()), (Matcher)Matchers.equalTo((Object)this.unitCount.getRejected()));
        MatcherAssert.assertThat((Object)((int)this.stats.getTotal()), (Matcher)Matchers.equalTo((Object)this.unitCount.getTotal()));
        MatcherAssert.assertThat((Object)((int)this.stats.getTranslated()), (Matcher)Matchers.equalTo((Object)(this.unitCount.getApproved() + this.unitCount.getTranslated())));
        MatcherAssert.assertThat((Object)((int)this.stats.getUntranslated()), (Matcher)Matchers.equalTo((Object)this.unitCount.getUntranslated()));
        MatcherAssert.assertThat((Object)((int)this.stats.getDraft()), (Matcher)Matchers.equalTo((Object)(this.unitCount.getNeedReview() + this.unitCount.getRejected())));
    }

    @Test
    public void getPercentTranslated() {
        this.unitCount = new TransUnitCount(5, 5, 5);
        this.stats = new TranslationStatistics(this.unitCount, this.localeId.getId());
        double percentTranslated = this.unitCount.getApproved() * 100 / this.unitCount.getTotal();
        MatcherAssert.assertThat((Object)this.stats.getPercentTranslated(), (Matcher)Matchers.equalTo((Object)percentTranslated));
    }

    @Test
    public void getPercentDraft() {
        this.unitCount = new TransUnitCount(5, 5, 5);
        this.stats = new TranslationStatistics(this.unitCount, this.localeId.getId());
        double percentDraft = (this.unitCount.getNeedReview() + this.unitCount.getRejected()) * 100 / this.unitCount.getTotal();
        MatcherAssert.assertThat((Object)this.stats.getPercentDraft(), (Matcher)Matchers.equalTo((Object)percentDraft));
    }

    @Test
    public void getPercentUntranslated() {
        this.unitCount = new TransUnitCount(5, 5, 5);
        this.stats = new TranslationStatistics(this.unitCount, this.localeId.getId());
        double percentUntranslated = this.unitCount.getUntranslated() * 100 / this.unitCount.getTotal();
        MatcherAssert.assertThat((Object)this.stats.getPercentUntranslated(), (Matcher)Matchers.equalTo((Object)percentUntranslated));
    }
}

