/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.dto.v1;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.zanata.common.ContentState;
import org.zanata.common.ContentType;
import org.zanata.common.LocaleId;
import org.zanata.common.ResourceType;
import org.zanata.rest.JaxbUtil;
import org.zanata.rest.dto.ExtensionValue;
import org.zanata.rest.dto.Glossary;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;
import org.zanata.rest.dto.Link;
import org.zanata.rest.dto.Links;
import org.zanata.rest.dto.Person;
import org.zanata.rest.dto.Project;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.extensions.gettext.HeaderEntry;
import org.zanata.rest.dto.extensions.gettext.PoHeader;
import org.zanata.rest.dto.extensions.gettext.PoTargetHeader;
import org.zanata.rest.dto.extensions.gettext.PotEntryHeader;
import org.zanata.rest.dto.extensions.gettext.TextFlowExtension;
import org.zanata.rest.dto.extensions.gettext.TextFlowTargetExtension;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.rest.dto.v1.JaxbTestUtil;

@Test(groups={"unit-tests"})
public class SerializationTest {
    protected ObjectMapper mapper;
    private final Logger log = LoggerFactory.getLogger(SerializationTest.class);

    @BeforeMethod
    public void setup() {
        this.mapper = new ObjectMapper();
    }

    private Person createPerson() {
        return new Person("id", "name");
    }

    @Test
    public void serializeAndDeserializeProject() throws JAXBException, JsonGenerationException, JsonMappingException, IOException, URISyntaxException {
        Project p = new Project().createSample();
        Links links = new Links();
        links.add((Object)new Link(new URI("http://www.zanata.org"), "", "linkType"));
        links.add((Object)new Link(new URI("http://www2.zanata.org"), "", "linkType"));
        p.setLinks(links);
        JaxbUtil.validateXml((Object)p, (Class[])new Class[0]);
        String output = this.mapper.writeValueAsString((Object)p);
        Project p2 = (Project)this.mapper.readValue(output, Project.class);
        MatcherAssert.assertThat((Object)p2, (Matcher)CoreMatchers.notNullValue());
        JaxbUtil.validateXml((Object)p2, (Class[])new Class[0]);
        p2 = JaxbTestUtil.roundTripXml(p, new Class[0]);
        System.out.println(p2);
        MatcherAssert.assertThat((Object)p2, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void serializeAndDeserializePerson() throws JAXBException, JsonGenerationException, JsonMappingException, IOException {
        Person p = this.createPerson();
        JaxbUtil.validateXml((Object)p, (Class[])new Class[0]);
        String output = this.mapper.writeValueAsString((Object)p);
        Person p2 = (Person)this.mapper.readValue(output, Person.class);
        MatcherAssert.assertThat((Object)p2, (Matcher)CoreMatchers.notNullValue());
        JaxbUtil.validateXml((Object)p2, (Class[])new Class[0]);
        p2 = JaxbTestUtil.roundTripXml(p, new Class[0]);
        MatcherAssert.assertThat((Object)p2, (Matcher)CoreMatchers.notNullValue());
    }

    private PoHeader createPoHeader() {
        return new PoHeader("hello world", new HeaderEntry[0]);
    }

    @Test(enabled=false)
    public void serializeAndDeserializeExtension() throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        PoHeader e = this.createPoHeader();
        JaxbUtil.validateXml((Object)e, (Class[])new Class[0]);
        String output = this.mapper.writeValueAsString((Object)e);
        PoHeader e2 = (PoHeader)this.mapper.readValue(output, PoHeader.class);
        JaxbUtil.validateXml((Object)e2, (Class[])new Class[0]);
        MatcherAssert.assertThat((Object)e2, (Matcher)CoreMatchers.instanceOf(PoHeader.class));
        e2 = JaxbTestUtil.roundTripXml(e, PoHeader.class);
        MatcherAssert.assertThat((Object)e2, (Matcher)CoreMatchers.instanceOf(PoHeader.class));
    }

    @Test(enabled=false)
    public void serializeAndDeserializeTranslationResource() throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        ResourceMeta res = new ResourceMeta("id");
        res.getExtensions(true).add((ExtensionValue)new PoHeader("comment", new HeaderEntry[]{new HeaderEntry("h1", "v1"), new HeaderEntry("h2", "v2")}));
        JaxbUtil.validateXml((Object)res, (Class[])new Class[]{PoHeader.class});
        String output = this.mapper.writeValueAsString((Object)res);
        ResourceMeta res2 = (ResourceMeta)this.mapper.readValue(output, ResourceMeta.class);
        MatcherAssert.assertThat((Object)res2.getExtensions().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(res2.getExtensions().iterator().next(), (Matcher)CoreMatchers.instanceOf(PoHeader.class));
        MatcherAssert.assertThat((Object)((PoHeader)res2.getExtensions().iterator().next()).getComment(), (Matcher)CoreMatchers.is((Object)"comment"));
        res2 = JaxbTestUtil.roundTripXml(res, PoHeader.class);
        MatcherAssert.assertThat((Object)res2, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)res2.getExtensions().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(res2.getExtensions().iterator().next(), (Matcher)CoreMatchers.instanceOf(PoHeader.class));
    }

    @Test(enabled=false)
    public void serializeSourceResource() throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        Resource sourceResource = new Resource("Acls.pot");
        sourceResource.setType(ResourceType.FILE);
        sourceResource.setContentType(ContentType.PO);
        sourceResource.setLang(LocaleId.EN);
        TextFlow tf = new TextFlow();
        tf.setContents(new String[]{"ttff"});
        TextFlow tf2 = new TextFlow();
        tf2.setContents(new String[]{"ttff2"});
        sourceResource.getTextFlows().add(tf);
        sourceResource.getTextFlows().add(tf2);
        sourceResource.getExtensions(true).add((ExtensionValue)new PoHeader("comment", new HeaderEntry[]{new HeaderEntry("h1", "v1"), new HeaderEntry("h2", "v2")}));
        JaxbUtil.validateXml((Object)sourceResource, (Class[])new Class[]{Resource.class});
        String output = this.mapper.writeValueAsString((Object)sourceResource);
        this.log.info(output);
        Resource res2 = (Resource)this.mapper.readValue(output, Resource.class);
        MatcherAssert.assertThat((Object)res2.getExtensions().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(res2.getExtensions().iterator().next(), (Matcher)CoreMatchers.instanceOf(PoHeader.class));
        MatcherAssert.assertThat((Object)((PoHeader)res2.getExtensions().iterator().next()).getComment(), (Matcher)CoreMatchers.is((Object)"comment"));
    }

    @Test(enabled=false)
    public void serializeAndDeserializeTextFlow() throws ValidationException, JsonGenerationException, JsonMappingException, IOException {
        TextFlow tf = new TextFlow();
        tf.setContents(new String[]{"ttff"});
        SimpleComment comment = new SimpleComment("test");
        PotEntryHeader pot = new PotEntryHeader();
        pot.setContext("context");
        pot.getReferences().add("fff");
        tf.getExtensions(true).add((ExtensionValue)comment);
        tf.getExtensions(true).add((ExtensionValue)pot);
        JaxbUtil.validateXml((Object)tf, (Class[])new Class[]{TextFlow.class});
        String output = this.mapper.writeValueAsString((Object)tf);
        TextFlow res2 = (TextFlow)this.mapper.readValue(output, TextFlow.class);
        MatcherAssert.assertThat((Object)res2.getExtensions(true).size(), (Matcher)CoreMatchers.is((Object)2));
        for (TextFlowExtension e : res2.getExtensions()) {
            if (e instanceof SimpleComment) {
                MatcherAssert.assertThat((Object)((SimpleComment)e).getValue(), (Matcher)CoreMatchers.is((Object)"test"));
            }
            if (!(e instanceof PotEntryHeader)) continue;
            MatcherAssert.assertThat((Object)((PotEntryHeader)e).getContext(), (Matcher)CoreMatchers.is((Object)"context"));
        }
    }

    @Test(enabled=false)
    public void serializeAndDeserializeTextFlowTarget() throws ValidationException, JsonGenerationException, JsonMappingException, IOException {
        TextFlowTarget tf = new TextFlowTarget();
        tf.setTranslator(this.createPerson());
        tf.setContents(new String[]{"ttff"});
        SimpleComment comment = new SimpleComment("testcomment");
        tf.getExtensions(true).add((ExtensionValue)comment);
        JaxbUtil.validateXml((Object)tf, (Class[])new Class[]{TextFlowTarget.class});
        String output = this.mapper.writeValueAsString((Object)tf);
        TextFlowTarget res2 = (TextFlowTarget)this.mapper.readValue(output, TextFlowTarget.class);
        MatcherAssert.assertThat((Object)res2.getExtensions(true).size(), (Matcher)CoreMatchers.is((Object)1));
        for (TextFlowTargetExtension e : res2.getExtensions()) {
            if (!(e instanceof SimpleComment)) continue;
            MatcherAssert.assertThat((Object)((SimpleComment)e).getValue(), (Matcher)CoreMatchers.is((Object)"testcomment"));
        }
    }

    @Test(enabled=false)
    public void serializeAndDeserializeTranslation() throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        TranslationsResource entity = new TranslationsResource();
        TextFlowTarget target = new TextFlowTarget("rest1");
        target.setContents(new String[]{"hello world"});
        target.setState(ContentState.Translated);
        target.setTranslator(new Person("root@localhost", "Admin user"));
        entity.getTextFlowTargets().add(target);
        entity.getExtensions(true);
        PoTargetHeader poTargetHeader = new PoTargetHeader("target header comment", new HeaderEntry[]{new HeaderEntry("ht", "vt1"), new HeaderEntry("th2", "tv2")});
        entity.getExtensions(true).add((ExtensionValue)poTargetHeader);
        JaxbUtil.validateXml((Object)entity, (Class[])new Class[]{TranslationsResource.class});
        String output = this.mapper.writeValueAsString((Object)entity);
        TranslationsResource res2 = (TranslationsResource)this.mapper.readValue(output, TranslationsResource.class);
        MatcherAssert.assertThat((Object)res2.getExtensions().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(res2.getExtensions().iterator().next(), (Matcher)CoreMatchers.instanceOf(PoTargetHeader.class));
        MatcherAssert.assertThat((Object)((PoTargetHeader)res2.getExtensions().iterator().next()).getComment(), (Matcher)CoreMatchers.is((Object)"target header comment"));
    }

    @Test(enabled=false)
    public void serializeAndDeserializeGlossary() throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        Glossary glossary = new Glossary();
        glossary.getSourceLocales().add("en-US");
        glossary.getTargetLocales().add("jp");
        glossary.getTargetLocales().add("de");
        GlossaryEntry entry = new GlossaryEntry();
        entry.setSrcLang(LocaleId.EN_US);
        entry.setSourcereference("source ref");
        GlossaryTerm term = new GlossaryTerm();
        term.setContent("testData1");
        term.setLocale(LocaleId.EN_US);
        term.getComments().add("comment1");
        term.getComments().add("comment2");
        term.getComments().add("comment3");
        GlossaryTerm term2 = new GlossaryTerm();
        term2.setContent("testData2");
        term2.setLocale(LocaleId.DE);
        term2.getComments().add("comment4");
        term2.getComments().add("comment5");
        term2.getComments().add("comment6");
        entry.getGlossaryTerms().add(term);
        entry.getGlossaryTerms().add(term2);
        glossary.getGlossaryEntries().add(entry);
        JaxbUtil.validateXml((Object)glossary, (Class[])new Class[]{Glossary.class});
        String output = this.mapper.writeValueAsString((Object)glossary);
        Glossary glossary2 = (Glossary)this.mapper.readValue(output, Glossary.class);
        MatcherAssert.assertThat((Object)glossary2.getGlossaryEntries().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((GlossaryEntry)glossary2.getGlossaryEntries().get(0)).getGlossaryTerms().size(), (Matcher)CoreMatchers.is((Object)2));
    }
}

