/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.db.plugin;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.zapodot.junit.db.plugin.InitializationPlugin;

public class LiquibaseInitializer
implements InitializationPlugin {
    private final Contexts contexts;
    private final LabelExpression labelExpression;
    private final String changeLog;
    private final ResourceAccessor resourceAccessor;
    private final Integer changesLimit;
    private final boolean addDbNameToContext;
    private final String defaultSchemaName;

    private LiquibaseInitializer(Contexts contexts, LabelExpression labelExpression, String changeLog, ResourceAccessor resourceAccessor, Integer changesLimit, boolean addDbNameToContext, String defaultSchemaName) {
        this.contexts = contexts;
        this.labelExpression = labelExpression;
        this.changeLog = changeLog;
        this.resourceAccessor = resourceAccessor;
        this.changesLimit = changesLimit;
        this.addDbNameToContext = addDbNameToContext;
        this.defaultSchemaName = defaultSchemaName;
    }

    public void connectionMade(String name, Connection connection) {
        if (this.defaultSchemaName != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(String.format("CREATE SCHEMA IF NOT EXISTS %s", this.defaultSchemaName));
            }
            catch (SQLException e) {
                throw new IllegalStateException("Could not create schema \"" + this.defaultSchemaName + "\"", e);
            }
        }
        Liquibase liquibase = this.createLiquibase(connection);
        if (this.addDbNameToContext) {
            this.contexts.add(name);
        }
        try {
            if (this.changesLimit == null) {
                liquibase.update(this.contexts, this.labelExpression);
            } else {
                liquibase.update(this.changesLimit.intValue(), this.contexts, this.labelExpression);
            }
        }
        catch (LiquibaseException e) {
            throw new IllegalArgumentException("An exception occurred while applying Liquibase changesets", e);
        }
    }

    private Liquibase createLiquibase(Connection connection) {
        try {
            JdbcConnection conn = new JdbcConnection(connection);
            Database database = this.resolveDatabase(connection);
            database.setConnection((DatabaseConnection)conn);
            if (this.defaultSchemaName != null) {
                database.setDefaultSchemaName(this.defaultSchemaName);
            }
            return new Liquibase(this.changeLog, this.resourceAccessor, database);
        }
        catch (LiquibaseException e) {
            throw new IllegalStateException("Could not initialize Liquibase", e);
        }
    }

    private final Database resolveDatabase(Connection connection) throws DatabaseException {
        return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String databaseChangeLog;
        private ResourceAccessor resourceAccessor;
        private List<String> contexts = new LinkedList<String>();
        private List<String> labels = new LinkedList<String>();
        private Integer changesToApply;
        private boolean addNameToContext = false;
        private String defaultSchemaName;

        public Builder withChangelogResource(String resource) {
            this.databaseChangeLog = resource;
            this.resourceAccessor = new ClassLoaderResourceAccessor();
            return this;
        }

        public Builder limitChanges(Integer limit) {
            this.changesToApply = limit;
            return this;
        }

        public Builder withContexts(String ... contexts) {
            if (contexts != null) {
                this.contexts.addAll(Arrays.asList(contexts));
            }
            return this;
        }

        public Builder addDatabaseNameToContext() {
            this.addNameToContext = true;
            return this;
        }

        public Builder withLabels(String ... labels) {
            if (labels != null) {
                this.labels.addAll(Arrays.asList(labels));
            }
            return this;
        }

        public Builder withDefaultSchemaName(String schemaName) {
            this.defaultSchemaName = schemaName;
            return this;
        }

        public LiquibaseInitializer build() {
            if (this.databaseChangeLog == null) {
                throw new IllegalArgumentException("You must provide a changelog file to the LiquibaseIntitializer Plugin builder");
            }
            try {
                if (this.resourceAccessor.openStream(null, this.databaseChangeLog) == null) {
                    throw new IllegalArgumentException(String.format("Can not load changelog from resource \"%s\". Does it exist?", this.databaseChangeLog));
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("An IO exception occurred while loading changelog from resource \"%s\"", this.databaseChangeLog), e);
            }
            return new LiquibaseInitializer(this.createContexts(), this.createLabels(), this.databaseChangeLog, this.resourceAccessor, this.changesToApply, this.addNameToContext, this.defaultSchemaName);
        }

        private LabelExpression createLabels() {
            return new LabelExpression(this.labels);
        }

        private Contexts createContexts() {
            return new Contexts(this.contexts);
        }
    }
}

