package pl.codewise.commons.aws.spring;

import pl.codewise.commons.aws.AwsClientsCache;
import pl.codewise.commons.aws.AwsCloudFactory;
import pl.codewise.commons.aws.cqrs.factories.AmazonClientBuilders;
import pl.codewise.commons.aws.cqrs.factories.ClientConstructors;
import pl.codewise.commons.aws.cqrs.factories.constructors.AmazonClientConfigurationProvider;
import pl.codewise.commons.aws.cqrs.factories.constructors.AmazonClientConstructors;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;
import pl.codewise.commons.aws.cqrs.utils.FileSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Optional;

@Configuration
public class AwsConfiguration {

    /**
     * This bean is optional meaning your application may create your own provider. If not defined, default values will
     * be used.
     */
    @Autowired
    private Optional<AmazonClientConfigurationProvider> amazonClientConfigurationProvider;

    @Bean
    public Awaitilities awaitilities() {
        return new Awaitilities();
    }

    @Bean
    public FileSystem fileSystem() {
        return new FileSystem();
    }

    @Bean
    public ClientConstructors clientConstructors() {
        return new AmazonClientConstructors(
                amazonClientConfigurationProvider.orElseGet(AmazonClientConfigurationProvider::new));
    }

    @Bean
    public AmazonClientBuilders amazonClientBuilders() {
        return new AmazonClientBuilders(clientConstructors());
    }

    @Bean
    public AwsCloudFactory awsCloudFactory(
            @Value("${s3.operations.put.file.retry.count:3}") int s3OperationsPutFileRetryCount,
            @Value("${s3.operations.get.file.retry.count:3}") int s3OperationsGetFileRetryCount,
            @Value("${autoscaling.wait.for.zero.instances.milliseconds:600000}") long waifForNoInService,
            @Value("${autoscaling.wait.for.group.shutdown.milliseconds:180000}") long waitForAutoScalingShutdown,
            @Value("${autoscaling.wait.for.instance.startup.milliseconds:900000}") long waitForInstanceStartup,
            @Value("${autoscaling.wait.for.pollInternal.milliseconds:10000}") long autoScalingPollInterval,
            @Value("${default.poll.internal.milliseconds:10000}") long defaultPollInterval) {
        return new AwsCloudFactory(awsClientsCache(), fileSystem(), awaitilities(), s3OperationsPutFileRetryCount,
                s3OperationsGetFileRetryCount, waifForNoInService, waitForAutoScalingShutdown, waitForInstanceStartup,
                autoScalingPollInterval, defaultPollInterval);
    }

    private AwsClientsCache awsClientsCache() {
        return new AwsClientsCache(amazonClientBuilders());
    }
}
