/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.convert.ConversionFailedException;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TwoWayBinding;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.core.forms.IValidatedComponent;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.PresentationStyleEnum;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.AccessibilityEnum;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.FormElementWithConfirmationSupport;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.Iconable;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableComponent;
import pl.fhframework.model.forms.attribute.IconAlignment;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.InputFieldDesignerPreviewProvider;
import pl.fhframework.model.forms.model.LabelPosition;
import pl.fhframework.model.forms.validation.ValidationFactory;
import pl.fhframework.validation.ConstraintViolation;
import pl.fhframework.validation.FieldValidationResult;
import pl.fhframework.validation.FormFieldHints;
import pl.fhframework.validation.IValidationResults;
import pl.fhframework.validation.ValidationManager;

@DesignerControl(defaultWidth=2)
public abstract class BaseInputField
extends FormElementWithConfirmationSupport
implements IChangeableByClient,
Iconable,
Boundable,
IValidatedComponent,
TableComponent<BaseInputField>,
IHasBoundableLabel {
    protected static final String ON_CHANGE_ATTR = "onChange";
    protected static final String RAW_VALUE_ATTR = "rawValue";
    protected static final String VALUE_ATTR = "value";
    protected static final String REQUIRED_ATTR = "required";
    protected static final String LABEL_ATTR = "label";
    protected static final String VALIDATION_LABEL_ATTR = "validationLabel";
    protected static final String PRESENTATION_STYLE_ATTR = "presentationStyle";
    protected static final String MESSAGE_FOR_FIELD_ATTR = "messageForField";
    protected static final String AUTOCOMPLETE_ATTR = "autocomplete";
    protected static final String HINT_INPUT_GROUP_ATTR = "hintInputGroup";
    @XMLProperty(value="hintInputGroup")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=86)
    @DocumentedComponentAttribute(defaultValue="STANDARD", value="Static presentation makes hint appears after clikc on '?' icon that will appear as input group element.")
    private Boolean hintInputGroup = false;
    private String rawValue = "";
    @JsonIgnore
    @TwoWayBinding
    @XMLProperty(value="value", aliases={"selectedItem"})
    @DesignerXMLProperty(commonUse=true, previewValueProvider=InputFieldDesignerPreviewProvider.class, priority=80, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Binding represents value from model of Form, used inside of '{}', like {model}.")
    private ModelBinding modelBinding;
    @XMLProperty
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on every action in input, that method will be executed. This method fires, when component loses focus.")
    @DesignerXMLProperty(priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    private ActionBinding onChange;
    private String label = "";
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=110, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component. Supports FHML - FH Markup Language.")
    private ModelBinding labelModelBinding;
    @JsonIgnore
    @XMLProperty(value="validationLabel")
    @DesignerXMLProperty(previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component used in validation messages. If not set, falls back to label attribute's value.")
    private ModelBinding validationLabelModelBinding;
    private PresentationStyleEnum presentationStyle;
    private String messageForField = "";
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(value="User can define validation rule for binded model using SpEL. Expression is based on properties of form's model and must be prefixed with '-' sign, eg. -prop1 < prop2")
    @DesignerXMLProperty(priority=90)
    private String validationRule;
    private boolean required;
    @JsonIgnore
    @XMLProperty(value="required")
    @DesignerXMLProperty(priority=5, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, defaultValue="false", value="User can define if component is required for Form. Binding changes may not be respected after initially showing this control.")
    private ModelBinding<Boolean> requiredBinding;
    private String icon;
    @JsonIgnore
    @XMLProperty(value="icon")
    @DocumentedComponentAttribute(boundable=true, value="Icon id. Please refer to http://fontawesome.io/icons/ for all available icons.")
    @DesignerXMLProperty(priority=84, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE)
    private ModelBinding<String> iconBinding;
    @XMLProperty(defaultValue="BEFORE")
    @DesignerXMLProperty(priority=83, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE)
    @DocumentedComponentAttribute(defaultValue="BEFORE", boundable=true, value="Icon alignment - possible values are before or after. Final alignment depends of component where this attribute is used.")
    private IconAlignment iconAlignment;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=95)
    @DocumentedComponentAttribute(value="Defines position of a label. Position is one of: up, down, left, right.")
    private LabelPosition labelPosition;
    @XMLProperty(defaultValue="60.0")
    @DocumentedComponentAttribute(defaultValue="60.0", value="Proportional size of input, inputSize should be set when labelPosition is \"left\" or \"right\".")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=91, allowedTypes={Double.class})
    private double inputSize = 60.0;
    @XMLProperty(defaultValue="")
    @DocumentedComponentAttribute(defaultValue="", value="Proportional size of label, labelSize should be set when labelPosition is \"left\" or \"right\". If this value is set, then inputSize property does not work.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=96, allowedTypes={String.class})
    private String labelSize = null;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=94)
    @DocumentedComponentAttribute(value="Defines label control id.")
    private String labelId;
    @JsonIgnore
    protected ValidationManager<BaseInputField> validationManager;
    @JsonIgnore
    protected boolean validConversion = true;
    private String autocomplete = null;
    @JsonIgnore
    @XMLProperty(value="autocomplete")
    @DesignerXMLProperty(commonUse=true, priority=110, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(boundable=true, value="Represents 'autocomplete' attribute. Help browsers suggest right content. More at : https://www.w3.org/TR/html52/sec-forms.html#autofill-detail-tokens")
    private ModelBinding autocompleteModelBinding;

    public BaseInputField(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        this.validationManager = this.createValidationManager();
    }

    public void updateModel(ValueChange valueChange) {
        this.rawValue = StringUtils.emptyToNull((String)valueChange.getMainValue());
        if (this.modelBinding != null) {
            try {
                this.updateBindingForValue(this.rawValue, this.modelBinding, this.modelBinding.getBindingExpression(), this.getOptionalFormatter());
                this.validConversion = true;
            }
            catch (FhBindingException cfe) {
                if (cfe.getCause() instanceof ConversionFailedException || cfe.getCause() instanceof ParseException) {
                    this.validConversion = false;
                    this.processCoversionException(cfe);
                }
                throw cfe;
            }
        }
    }

    protected void processCoversionException(FhBindingException cfe) {
        throw cfe;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_CHANGE_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onChange);
        }
        return super.getEventHandler(eventData);
    }

    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        if (this.iconBinding != null) {
            this.icon = this.resolveIconBinding((FormElement)this, elementChanges);
        }
        if (this.requiredBinding != null) {
            this.required = this.requiredBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.required, REQUIRED_ATTR);
        }
        boolean refreshView = this.processValueBinding(elementChanges);
        refreshView |= this.processLabelBinding(elementChanges);
        this.prepareComponentAfterValidation(elementChanges);
        if (refreshView |= this.processAutocompleteBinding(elementChanges)) {
            this.refreshView();
        }
        return elementChanges;
    }

    protected String convertToRaw(BindingResult<?> bindingResult) {
        if (bindingResult == null) {
            return "";
        }
        Optional converterName = this.getOptionalFormatter();
        return this.convertBindingValueToString(bindingResult, converterName);
    }

    protected boolean processValueBinding(ElementChanges elementChanges) {
        BindingResult bindingResult = this.modelBinding != null ? this.modelBinding.getBindingResult() : null;
        this.skipSettingPresentation(elementChanges, this.getForm());
        String newRawValue = this.convertToRaw(bindingResult);
        if (!this.areModelValuesTheSame(newRawValue, this.rawValue)) {
            this.rawValue = newRawValue;
            elementChanges.addChange(RAW_VALUE_ATTR, (Object)this.rawValue);
            return true;
        }
        return false;
    }

    public void calculateAvailability() {
        super.calculateAvailability();
        this.checkBinding();
    }

    protected void checkBinding() {
        if (!(this.getAvailability() != null && this.getAvailability() != AccessibilityEnum.EDIT || this.modelBinding == null || this.modelBinding.canChange())) {
            this.setAvailability(AccessibilityEnum.VIEW);
        }
    }

    @Deprecated
    public void setModelBindingAdHoc(String binding) {
        this.setModelBinding((ModelBinding)this.createAdHocModelBinding(binding));
    }

    @Deprecated
    public void setLabelModelBindingAdHoc(String labelBinding) {
        this.setLabelModelBinding((ModelBinding)this.createAdHocModelBinding(labelBinding));
    }

    protected boolean processLabelBinding(ElementChanges elementChanges) {
        String newLabelValue;
        BindingResult labelBidingResult = this.labelModelBinding != null ? this.labelModelBinding.getBindingResult() : null;
        String string = newLabelValue = labelBidingResult == null ? null : this.convertBindingValueToString(labelBidingResult);
        if (!this.areValuesTheSame(newLabelValue, this.label)) {
            this.label = newLabelValue;
            elementChanges.addChange(LABEL_ATTR, (Object)this.label);
            return true;
        }
        return false;
    }

    protected boolean processAutocompleteBinding(ElementChanges elementChanges) {
        String newValue;
        BindingResult bidingResult = this.autocompleteModelBinding != null ? this.autocompleteModelBinding.getBindingResult() : null;
        String string = newValue = bidingResult == null ? null : this.convertBindingValueToString(bidingResult);
        if (!this.areValuesTheSame(newValue, this.autocomplete)) {
            this.autocomplete = newValue;
            elementChanges.addChange(AUTOCOMPLETE_ATTR, (Object)this.autocomplete);
            return true;
        }
        return false;
    }

    public void validate() {
        if (this.modelBinding != null && this.modelBinding.getBindingResult() != null) {
            this.processValidationForThisComponent();
        }
    }

    public void prepareComponentAfterValidation(ElementChanges elementChanges) {
        if (this.getForm().getAbstractUseCase() != null) {
            List fieldValidationResultFor;
            IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
            BindingResult bindingResult = this.getTargetModelBinding() != null ? this.getTargetModelBinding().getBindingResult() : null;
            List list = fieldValidationResultFor = bindingResult == null ? Collections.emptyList() : validationResults.getFieldValidationResultFor(bindingResult.getParent(), bindingResult.getAttributeName());
            if (this.getAvailability() != AccessibilityEnum.EDIT) {
                fieldValidationResultFor.removeIf(FieldValidationResult::isFormSource);
            }
            this.processStylesAndHints(elementChanges, fieldValidationResultFor);
        }
    }

    @JsonIgnore
    public List<ModelBinding> getAllBingings() {
        ArrayList<ModelBinding> allBindings = new ArrayList<ModelBinding>();
        allBindings.add(this.getModelBinding());
        allBindings.add(this.getLabelModelBinding());
        return allBindings;
    }

    protected List<ConstraintViolation<BaseInputField>> processValidationForThisComponent() {
        List formComponentValidationResult = this.validationManager.validate((Object)this);
        IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
        BindingResult bindingResult = this.getTargetModelBinding().getBindingResult();
        for (ConstraintViolation constrain : formComponentValidationResult) {
            validationResults.addCustomMessageForComponent((IValidatedComponent)this, bindingResult.getParent(), bindingResult.getAttributeName(), constrain.getMessage(), PresentationStyleEnum.BLOCKER);
        }
        return formComponentValidationResult;
    }

    protected ValidationManager<BaseInputField> createValidationManager() {
        return ValidationFactory.getInstance().getBasicValidationProcess();
    }

    protected void processStylesAndHints(ElementChanges elementChanges, List<FieldValidationResult> fieldValidationResults) {
        FormFieldHints formFieldHints = this.processPresentationStyle(elementChanges, fieldValidationResults);
        this.processMessagesForHints(elementChanges, formFieldHints);
    }

    private void processMessagesForHints(ElementChanges elementChanges, FormFieldHints formFieldHints) {
        String oldHints = this.messageForField;
        String string = this.messageForField = formFieldHints != null ? formFieldHints.getHints() : null;
        if (!Objects.equals(oldHints, this.messageForField)) {
            elementChanges.addChange(MESSAGE_FOR_FIELD_ATTR, (Object)this.messageForField);
        }
    }

    protected FormFieldHints processPresentationStyle(ElementChanges elementChanges, List<FieldValidationResult> fieldValidationResults) {
        BindingResult bindingResult;
        PresentationStyleEnum oldPresentationStyle = this.presentationStyle;
        FormFieldHints formFieldHints = null;
        BindingResult bindingResult2 = bindingResult = this.getTargetModelBinding() != null ? this.getTargetModelBinding().getBindingResult() : null;
        this.presentationStyle = bindingResult != null ? ((formFieldHints = this.calculatePresentationStyle(this.getTargetModelBinding().getBindingResult())) != null ? formFieldHints.getPresentationStyleEnum() : null) : null;
        if (!(fieldValidationResults.isEmpty() || this.presentationStyle != null && this.presentationStyle == PresentationStyleEnum.BLOCKER)) {
            this.presentationStyle = PresentationStyleEnum.BLOCKER;
        }
        if (oldPresentationStyle != this.presentationStyle) {
            elementChanges.addChange(PRESENTATION_STYLE_ATTR, (Object)this.presentationStyle);
        }
        return formFieldHints;
    }

    protected ModelBinding getTargetModelBinding() {
        return this.getModelBinding();
    }

    protected FormFieldHints calculatePresentationStyle(BindingResult bindingResult) {
        if (bindingResult.getParent() != null && bindingResult.getAttributeName() != null && this.getAvailability() != AccessibilityEnum.HIDDEN) {
            FormFieldHints fieldHints = this.getForm().getAbstractUseCase().getUserSession().getValidationResults().getPresentationStyleForField(bindingResult.getParent(), bindingResult.getAttributeName());
            if (fieldHints == null) {
                fieldHints = this.getForm().getFieldsHighlightingList().getPresentationStyleForField(bindingResult.getParent(), bindingResult.getAttributeName());
            }
            return fieldHints;
        }
        return null;
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField inputFieldClone) {
        TableComponent.super.doCopy(table, iteratorReplacements, inputFieldClone);
        inputFieldClone.setModelBinding(table.getRowBinding(this.getModelBinding(), (Component)inputFieldClone, iteratorReplacements));
        inputFieldClone.setOnChange(table.getRowBinding(this.getOnChange(), (Component)inputFieldClone, iteratorReplacements));
        inputFieldClone.setLabelModelBinding(table.getRowBinding(this.getLabelModelBinding(), (Component)inputFieldClone, iteratorReplacements));
        inputFieldClone.setValidationRule(table.getRowBinding(this.getValidationRule(), iteratorReplacements, false));
        inputFieldClone.setRequiredBinding((ModelBinding<Boolean>)table.getRowBinding(this.getRequiredBinding(), (Component)inputFieldClone, iteratorReplacements));
        inputFieldClone.setIconBinding((ModelBinding<String>)table.getRowBinding(this.getIconBinding(), (Component)inputFieldClone, iteratorReplacements));
        inputFieldClone.setLabelPosition(this.getLabelPosition());
        inputFieldClone.setInputSize(this.getInputSize());
        inputFieldClone.setLabelSize(this.getLabelSize());
        inputFieldClone.setLabelId(this.getLabelId());
    }

    protected String convertMainValueToString(Object value, Optional<String> converterName) {
        return this.convertValueToString(value, converterName.orElse(null));
    }

    public void setOnChange(ActionBinding onChange) {
        this.onChange = onChange;
    }

    public IActionCallbackContext setOnChange(IActionCallback onChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onChange, this::setOnChange);
    }

    public Boolean getHintInputGroup() {
        return this.hintInputGroup;
    }

    public void setHintInputGroup(Boolean hintInputGroup) {
        this.hintInputGroup = hintInputGroup;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
    }

    public ModelBinding getModelBinding() {
        return this.modelBinding;
    }

    public void setModelBinding(ModelBinding modelBinding) {
        this.modelBinding = modelBinding;
    }

    public ActionBinding getOnChange() {
        return this.onChange;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public ModelBinding getValidationLabelModelBinding() {
        return this.validationLabelModelBinding;
    }

    public void setValidationLabelModelBinding(ModelBinding validationLabelModelBinding) {
        this.validationLabelModelBinding = validationLabelModelBinding;
    }

    public PresentationStyleEnum getPresentationStyle() {
        return this.presentationStyle;
    }

    public void setPresentationStyle(PresentationStyleEnum presentationStyle) {
        this.presentationStyle = presentationStyle;
    }

    public String getMessageForField() {
        return this.messageForField;
    }

    public String getValidationRule() {
        return this.validationRule;
    }

    public void setValidationRule(String validationRule) {
        this.validationRule = validationRule;
    }

    public boolean isRequired() {
        return this.required;
    }

    public ModelBinding<Boolean> getRequiredBinding() {
        return this.requiredBinding;
    }

    public void setRequiredBinding(ModelBinding<Boolean> requiredBinding) {
        this.requiredBinding = requiredBinding;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public ModelBinding<String> getIconBinding() {
        return this.iconBinding;
    }

    public void setIconBinding(ModelBinding<String> iconBinding) {
        this.iconBinding = iconBinding;
    }

    @Override
    public IconAlignment getIconAlignment() {
        return this.iconAlignment;
    }

    public void setIconAlignment(IconAlignment iconAlignment) {
        this.iconAlignment = iconAlignment;
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public double getInputSize() {
        return this.inputSize;
    }

    public void setInputSize(double inputSize) {
        this.inputSize = inputSize;
    }

    public String getLabelSize() {
        return this.labelSize;
    }

    public void setLabelSize(String labelSize) {
        this.labelSize = labelSize;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }

    public boolean isValidConversion() {
        return this.validConversion;
    }

    public String getAutocomplete() {
        return this.autocomplete;
    }

    public ModelBinding getAutocompleteModelBinding() {
        return this.autocompleteModelBinding;
    }

    public void setAutocompleteModelBinding(ModelBinding autocompleteModelBinding) {
        this.autocompleteModelBinding = autocompleteModelBinding;
    }
}

