/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.model.TextAlignEnum;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.BaseInputFieldWithKeySupport;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.config.BasicControlsConfiguration;
import pl.fhframework.model.forms.designer.InputFieldDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.RegExAttributeDesignerSupport;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.utils.LanguageResolver;
import pl.fhframework.model.forms.validation.ValidationFactory;
import pl.fhframework.tools.loading.IBodyXml;
import pl.fhframework.validation.ValidationManager;

@DesignerControl(defaultWidth=3)
@TemplateControl(tagName="fh-input-text")
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, value="InputText component is responsible for displaying simple field, where user can write some data plus label representing this field.", icon="fa fa-edit")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@OverridenPropertyAnnotations(property="modelBinding", designerXmlProperty={@DesignerXMLProperty(allowedTypes={String.class}, commonUse=true, previewValueProvider=InputFieldDesignerPreviewProvider.class, priority=80, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)})
public class InputText
extends BaseInputFieldWithKeySupport
implements IBodyXml {
    private static final String ON_INPUT_ATTR = "onInput";
    private static final String MASK_BINDING = "maskBinding";
    private static final String MASK = "mask";
    private static final String MAX_LENGTH_BINDING = "maxLengthBinding";
    private static final String FORMATTER_BINDING = "formatterBinding";
    private static final String REQUIRED_REGEX_BINDING = "requiredRegexBinding";
    @XMLProperty
    @DocumentedComponentAttribute(value="If there is some value, then there will be visible placeholder for <input>.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=82)
    private String placeholder;
    @XMLProperty
    @DocumentedComponentAttribute(value="If there will be value greater then 0, then InputText component will be represented as html tag: <textarea></textarea>. Otherwise, simple <input/>.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=93)
    private Integer rowsCount;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=92)
    @DocumentedComponentAttribute(value="Alignment of text inside input.")
    private TextAlignEnum textAlign;
    @XMLProperty(defaultValue="65535")
    @DocumentedComponentAttribute(value="Maximum length of value")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=90)
    private Integer maxLength;
    @JsonIgnore
    @XMLProperty(value="maxLengthBinding")
    @DocumentedComponentAttribute(boundable=true, value="Maximum length of value")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=81)
    private ModelBinding maxLengthBinding;
    @XMLProperty
    @DocumentedComponentAttribute(value="Formatter mask")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=96)
    private String mask;
    @XMLProperty
    @DocumentedComponentAttribute(value="Should mask characters be added just in time typing.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=96)
    private Boolean maskDynamic;
    @XMLProperty
    @DocumentedComponentAttribute(value="Can mask characters be overriden.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=96)
    private Boolean maskInsertMode;
    @XMLProperty
    @DocumentedComponentAttribute(value="Custom symbol to use in mask. First character is always validator, second part defines allowed characters (between square brackets). Multiple values are separated with double pipe (\"||\". For example: x[123]||d[1-8].")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=95)
    private String maskDefinition;
    @JsonIgnore
    @XMLProperty(value="maskBinding")
    @DocumentedComponentAttribute(boundable=true, value="Formatter mask.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=94)
    private ModelBinding maskBinding;
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(value="Regular expression expected to be matched by input value (if present)")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=50, support=RegExAttributeDesignerSupport.class)
    private String requiredRegex;
    @JsonIgnore
    @XMLProperty(value="requiredRegexBinding")
    @DocumentedComponentAttribute(boundable=true, value="Regular expression expected to be matched by input value (if present)")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC)
    private ModelBinding requiredRegexBinding;
    @JsonIgnore
    private Pattern requiredRegexPattern;
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(boundable=true, value="Validation message show if requiredRegex expression is not matched by input value (if present)")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=49)
    private ModelBinding<String> requiredRegexMessage;
    @XMLProperty
    @DocumentedComponentAttribute(value="Type - text, password")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=92)
    private String inputType;
    @XMLProperty
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on every action in input,  that method will be executed. Action is fired, while component is active.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR, priority=110)
    private ActionBinding onInput;
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(value="Id of formatter which will format object to String. It must be consistent with value of pl.fhframework.formatter.FhFormatter annotation.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=93)
    private String formatter;
    @JsonIgnore
    @XMLProperty(value="formatterBinding")
    @DocumentedComponentAttribute(boundable=true, value="Id of formatter which will format object to String. It must be consistent with value of pl.fhframework.formatter.FhFormatter annotation.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC)
    private ModelBinding formatterBinding;
    private String language;

    public InputText(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        this.updateRegexPattern();
    }

    private void updateRegexPattern() {
        if (this.requiredRegex != null) {
            try {
                this.requiredRegexPattern = Pattern.compile(this.requiredRegex);
            }
            catch (PatternSyntaxException e) {
                FhLogger.error((String)("Invalid pattern " + this.requiredRegex), (Object[])new Object[0]);
            }
        } else {
            this.requiredRegexPattern = null;
        }
    }

    @Override
    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_INPUT_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onInput);
        }
        return super.getEventHandler(eventData);
    }

    @JsonIgnore
    public Optional<String> getOptionalFormatter() {
        return Optional.ofNullable(this.formatter);
    }

    @Override
    public InputText createNewSameComponent() {
        return new InputText(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField baseClone) {
        super.doCopy(table, iteratorReplacements, baseClone);
        InputText clone = (InputText)baseClone;
        clone.setPlaceholder(this.getPlaceholder());
        clone.setRowsCount(this.getRowsCount());
        clone.setMaxLength(this.getMaxLength());
        clone.setMask(this.getMask());
        clone.setMaskDefinition(this.getMaskDefinition());
        clone.setMaskDynamic(this.getMaskDynamic());
        clone.setMaskBinding(table.getRowBinding(this.getMaskBinding(), (Component)clone, iteratorReplacements));
        clone.setInputType(this.getInputType());
        clone.setOnInput(table.getRowBinding(this.getOnInput(), (Component)clone, iteratorReplacements));
        clone.setFormatter(this.getFormatter());
        clone.setMaxLengthBinding(table.getRowBinding(this.getMaxLengthBinding(), (Component)clone, iteratorReplacements));
        clone.setFormatterBinding(table.getRowBinding(this.getFormatterBinding(), (Component)clone, iteratorReplacements));
        clone.setRequiredRegexBinding(table.getRowBinding(this.getRequiredRegexBinding(), (Component)clone, iteratorReplacements));
    }

    public void setBody(String body) {
        this.setModelBindingAdHoc(body);
    }

    public String getBodyAttributeName() {
        return "value";
    }

    private void processMask(ElementChanges elementChanges) {
        String mask;
        if (this.maskBinding == null) {
            return;
        }
        BindingResult maskBindingResult = this.maskBinding.getBindingResult();
        if (maskBindingResult != null && !this.areValuesTheSame(mask = this.convertValueToString(maskBindingResult.getValue()), this.mask)) {
            this.refreshView();
            this.mask = mask;
            elementChanges.addChange(MASK, (Object)this.mask);
        }
    }

    private void processMaxLength(ElementChanges elementChanges) {
        Integer maxLength;
        if (this.maxLengthBinding == null) {
            if (this.maxLength == null) {
                this.maxLength = BasicControlsConfiguration.getInstance().getInputTextMaxLength();
            }
            return;
        }
        BindingResult maxLengthBindingResult = this.maxLengthBinding.getBindingResult();
        if (maxLengthBindingResult != null && !this.areValuesTheSame(maxLength = (Integer)this.convertValue(maxLengthBindingResult.getValue(), Integer.class), this.maxLength)) {
            this.refreshView();
            this.maxLength = maxLength;
            elementChanges.addChange(MAX_LENGTH_BINDING, (Object)this.maxLength);
        }
    }

    private void processFormatter() {
        Object value;
        String formatter;
        if (this.formatterBinding == null) {
            return;
        }
        BindingResult formatterBindingResult = this.formatterBinding.getBindingResult();
        if (formatterBindingResult != null && !this.areValuesTheSame(formatter = (value = formatterBindingResult.getValue()) == null ? null : this.convertValueToString(value), this.formatter)) {
            this.refreshView();
            this.formatter = formatter;
        }
    }

    private void processRequiredRegex() {
        Object value;
        String requiredRegex;
        if (this.requiredRegexBinding == null) {
            return;
        }
        BindingResult requiredRegexBindingResult = this.requiredRegexBinding.getBindingResult();
        if (requiredRegexBindingResult != null && !this.areValuesTheSame(requiredRegex = (value = requiredRegexBindingResult.getValue()) == null ? null : this.convertValueToString(value), this.requiredRegex)) {
            this.refreshView();
            this.requiredRegex = requiredRegex;
            this.updateRegexPattern();
        }
    }

    @Override
    public ElementChanges updateView() {
        this.processFormatter();
        ElementChanges elementChanges = super.updateView();
        this.processMask(elementChanges);
        this.processMaxLength(elementChanges);
        this.processRequiredRegex();
        this.language = LanguageResolver.languageChanges(this.getForm().getAbstractUseCase().getUserSession(), this.language, elementChanges);
        return elementChanges;
    }

    @Override
    protected ValidationManager<BaseInputField> createValidationManager() {
        return ValidationFactory.getInstance().getInputTextValidationProcess();
    }

    public void setOnInput(ActionBinding onInput) {
        this.onInput = onInput;
    }

    public IActionCallbackContext setOnInput(IActionCallback onInput) {
        return CallbackActionBinding.createAndSet((IActionCallback)onInput, this::setOnInput);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public Integer getRowsCount() {
        return this.rowsCount;
    }

    public void setRowsCount(Integer rowsCount) {
        this.rowsCount = rowsCount;
    }

    public TextAlignEnum getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlignEnum textAlign) {
        this.textAlign = textAlign;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public ModelBinding getMaxLengthBinding() {
        return this.maxLengthBinding;
    }

    public void setMaxLengthBinding(ModelBinding maxLengthBinding) {
        this.maxLengthBinding = maxLengthBinding;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public Boolean getMaskDynamic() {
        return this.maskDynamic;
    }

    public void setMaskDynamic(Boolean maskDynamic) {
        this.maskDynamic = maskDynamic;
    }

    public Boolean getMaskInsertMode() {
        return this.maskInsertMode;
    }

    public void setMaskInsertMode(Boolean maskInsertMode) {
        this.maskInsertMode = maskInsertMode;
    }

    public String getMaskDefinition() {
        return this.maskDefinition;
    }

    public void setMaskDefinition(String maskDefinition) {
        this.maskDefinition = maskDefinition;
    }

    public ModelBinding getMaskBinding() {
        return this.maskBinding;
    }

    public void setMaskBinding(ModelBinding maskBinding) {
        this.maskBinding = maskBinding;
    }

    public String getRequiredRegex() {
        return this.requiredRegex;
    }

    public void setRequiredRegex(String requiredRegex) {
        this.requiredRegex = requiredRegex;
    }

    public ModelBinding getRequiredRegexBinding() {
        return this.requiredRegexBinding;
    }

    public void setRequiredRegexBinding(ModelBinding requiredRegexBinding) {
        this.requiredRegexBinding = requiredRegexBinding;
    }

    public Pattern getRequiredRegexPattern() {
        return this.requiredRegexPattern;
    }

    public ModelBinding<String> getRequiredRegexMessage() {
        return this.requiredRegexMessage;
    }

    public void setRequiredRegexMessage(ModelBinding<String> requiredRegexMessage) {
        this.requiredRegexMessage = requiredRegexMessage;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public ActionBinding getOnInput() {
        return this.onInput;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public ModelBinding getFormatterBinding() {
        return this.formatterBinding;
    }

    public void setFormatterBinding(ModelBinding formatterBinding) {
        this.formatterBinding = formatterBinding;
    }

    public String getLanguage() {
        return this.language;
    }
}

