/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.plugins.cache.standalone;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.fhframework.configuration.FHConfiguration;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.util.StringUtils;

@Configuration
public class StandaloneCacheConfiguration {
    @Autowired
    private FHConfiguration fhConfiguration;
    @Value(value="${fh.cache.jgroups.configurationFile:jgroups_fh_default.xml}")
    private String jgroupsConfigurationFile;

    @Bean
    public EmbeddedCacheManager infiniSpanCacheManager(@Qualifier(value="asyncReplicationConfig") org.infinispan.configuration.cache.Configuration asyncReplicationConfig) {
        String clusterName = this.fhConfiguration.getClusterName();
        FhLogger.info(this.getClass(), (String)("Using infinispan cache cluster name: " + clusterName), (Object[])new Object[0]);
        TransportConfigurationBuilder transportConfigurationBuilder = new GlobalConfigurationBuilder().transport().clusterName(clusterName).defaultTransport();
        if (!StringUtils.isNullOrEmpty((String)this.jgroupsConfigurationFile)) {
            transportConfigurationBuilder.addProperty("configurationFile", this.jgroupsConfigurationFile);
        }
        GlobalConfiguration conf = transportConfigurationBuilder.build();
        return new DefaultCacheManager(conf, asyncReplicationConfig);
    }

    @Bean(name={"asyncReplicationConfig"})
    public org.infinispan.configuration.cache.Configuration asyncReplicationConfig() {
        return new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_ASYNC).eviction().type(EvictionType.COUNT).size(10000L).expiration().lifespan(10L, TimeUnit.SECONDS).build();
    }

    @Bean
    public Cache<String, String> loginsWithWebSocketCache(@Autowired EmbeddedCacheManager container, @Qualifier(value="asyncReplicationConfig") org.infinispan.configuration.cache.Configuration asyncReplicationConfig) {
        String CACHE_NAME = "loginsWithWebSocket";
        container.defineConfiguration("loginsWithWebSocket", asyncReplicationConfig);
        return container.getCache("loginsWithWebSocket");
    }

    @Bean
    public Cache<String, Long> userLogouts(@Autowired EmbeddedCacheManager container, @Qualifier(value="asyncReplicationConfig") org.infinispan.configuration.cache.Configuration asyncReplicationConfig) {
        String CACHE_NAME = "userLogouts";
        container.defineConfiguration("userLogouts", asyncReplicationConfig);
        return container.getCache("userLogouts");
    }
}

