/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.jws.WebParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import pl.fhframework.core.ResourceNotFoundException;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.resource.ImageRepository;
import pl.fhframework.core.resource.MarkdownRepository;
import pl.fhframework.core.util.FileUtils;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.event.dto.ForcedLogoutEvent;
import pl.fhframework.subsystems.ModuleRegistry;
import pl.fhframework.subsystems.Subsystem;

@Controller
public class HttpMappings {
    @Autowired
    private ImageRepository imageRepository;
    @Resource
    @Lazy
    private LocaleResolver localeResolver;
    @Autowired
    private MarkdownRepository markdownRepository;
    @Value(value="${fh.web.guests.allowed:false}")
    private boolean guestsAllowed;
    @Value(value="${server.logout.path:}")
    private String logoutPath;
    @Autowired
    @Lazy
    private MessageService messageService;

    @Bean
    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource bundleMessageSource = new ReloadableResourceBundleMessageSource();
        bundleMessageSource.setBasenames(new String[]{"classpath:i18n/messages", "classpath:i18n/app_messages"});
        bundleMessageSource.setDefaultEncoding("UTF-8");
        return bundleMessageSource;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public ModelAndView login(@RequestParam(value="error", required=false) String error, @RequestParam(value="logout", required=false) String logout, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = this.getLocale(request, response);
        response.setLocale(locale);
        ModelAndView model = new ModelAndView();
        if (error != null) {
            model.addObject("message", (Object)this.getErrorMessage(request, response, "SPRING_SECURITY_LAST_EXCEPTION"));
        }
        if (logout != null) {
            if (this.guestsAllowed) {
                model.setViewName("redirect:/");
                return model;
            }
            if (logout.equals(ForcedLogoutEvent.Reason.LOGOUT_TIMEOUT.getCode())) {
                model.addObject("message", (Object)this.$("fh.infos.successfully_logged_out", locale));
            } else if (logout.equals(ForcedLogoutEvent.Reason.LOGOUT_FORCE.getCode())) {
                model.addObject("message", (Object)this.$("fh.infos.successfully_logged_out_by_admin", locale));
            } else {
                model.addObject("message", (Object)this.$("fh.infos.successfully_logged_out", locale));
            }
        }
        model.setViewName("login");
        return model;
    }

    @RequestMapping(value={"/${fh.web.guests.authenticate.path:authenticateGuest}"}, method={RequestMethod.GET})
    public ModelAndView authenticateGuest() {
        ModelAndView model = new ModelAndView();
        model.setViewName("redirect:/");
        return model;
    }

    @RequestMapping(value={"/image"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public ResponseEntity image(@WebParam(name="module") String module, @WebParam(name="path") String path) throws ResourceNotFoundException {
        Optional<Subsystem> subsystemOptional = ModuleRegistry.getLoadedModules().stream().filter(c -> c.getName().equals(module)).findAny();
        Subsystem subsystem = subsystemOptional.orElseThrow(ResourceNotFoundException::new);
        ImageRepository.ImageEntry resource = (ImageRepository.ImageEntry)this.imageRepository.getImage(subsystem.getName(), path).orElseThrow(ResourceNotFoundException::new);
        return this.getFile(resource.getFile());
    }

    @RequestMapping(value={"/markdown"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public ResponseEntity markdown(@WebParam(name="module") String module, @WebParam(name="path") String path) throws ResourceNotFoundException {
        Optional<Subsystem> subsystemOptional = ModuleRegistry.getLoadedModules().stream().filter(c -> c.getName().equals(module)).findAny();
        Subsystem subsystem = subsystemOptional.orElseThrow(ResourceNotFoundException::new);
        Optional resource = this.markdownRepository.getFile(subsystem.getName(), path);
        resource.orElseThrow(ResourceNotFoundException::new);
        return this.getFile((File)resource.get());
    }

    @RequestMapping(value={"/sessionUsed"}, method={RequestMethod.GET})
    public ModelAndView sessionUsed(HttpServletRequest request) {
        ModelAndView model = new ModelAndView();
        model.setViewName("sessionUsed");
        return model;
    }

    @RequestMapping(value={"/", "/index"}, method={RequestMethod.GET})
    public ModelAndView index(HttpServletRequest request) {
        return new ModelAndView("index");
    }

    @RequestMapping(value={"/autologout"}, method={RequestMethod.GET})
    public ModelAndView timeout(@RequestParam(value="reason", required=false) String reason, HttpServletRequest request) {
        ModelAndView model = new ModelAndView();
        if (!StringUtils.isNullOrEmpty((String)this.logoutPath) && !Objects.equals("logout", this.logoutPath)) {
            model.setViewName("redirect:/" + this.logoutPath);
            return model;
        }
        if (!StringUtils.isNullOrEmpty((String)reason)) {
            model.addObject("logout", (Object)reason);
        }
        model.setViewName("redirect:/login");
        return model;
    }

    private String getErrorMessage(HttpServletRequest request, HttpServletResponse response, String key) {
        Exception exception = (Exception)request.getSession().getAttribute(key);
        String error = "";
        Locale locale = this.getLocale(request, response);
        error = exception instanceof BadCredentialsException ? this.$("fh.errors.invalid_username_or_password", locale) : (exception instanceof LockedException ? this.$("fh.errors.account_is_blocked", locale) : (exception instanceof DisabledException ? this.$("fh.errors.account_is_blocked", locale) : (exception instanceof AccountExpiredException ? this.$("fh.errors.account_expired", locale) : (exception instanceof SessionAuthenticationException ? exception.getMessage() : this.$("fh.errors.invalid_username_or_password", locale)))));
        return error;
    }

    private Locale getLocale(HttpServletRequest request, HttpServletResponse response) {
        return this.localeResolver.resolveLocale(request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseEntity getFile(File file) throws ResourceNotFoundException {
        try (FileInputStream stream = new FileInputStream(file);){
            byte[] bytes = FileUtils.getAllBytes((InputStream)stream);
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().lastModified(file.lastModified())).contentLength(file.length()).contentType(this.getFileContentType(file)).body((Object)bytes);
            return responseEntity;
        }
        catch (IOException e) {
            FhLogger.error((String)("Error while reading stream: " + e.getMessage()), (Throwable)e);
            throw new ResourceNotFoundException();
        }
    }

    private MediaType getFileContentType(File file) {
        if (FilenameUtils.isExtension((String)file.getName(), Arrays.asList("PNG", "png"))) {
            return MediaType.IMAGE_PNG;
        }
        if (FilenameUtils.isExtension((String)file.getName(), Arrays.asList("GIF", "gif"))) {
            return MediaType.IMAGE_GIF;
        }
        return MediaType.IMAGE_JPEG;
    }

    private String $(String key, Locale locale) {
        return this.messageService.getAllBundles().getMessage(key, null, locale, key);
    }
}

