/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.DelegatingWebMvcConfiguration;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

@Configuration
@Order(value=1)
public class WebConfig
extends DelegatingWebMvcConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WebConfig.class);
    @Value(value="${fhframework.language.default:pl}")
    private String defaultLang;

    @Bean
    public LocaleResolver localeResolver() {
        log.info("************* Start cookie locale resolver...");
        CookieLocaleResolver resolver = new CookieLocaleResolver();
        resolver.setCookieName("USERLANG");
        resolver.setDefaultLocale(Locale.forLanguageTag(this.defaultLang));
        return resolver;
    }
}

