/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import pl.fhframework.accounts.SecurityFilter;
import pl.fhframework.accounts.SingleLoginLockManager;
import pl.fhframework.config.FhWebConfiguration;
import pl.fhframework.core.security.SecurityProviderInitializer;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${fh.web.guests.allowed:false}")
    private boolean guestsAllowed;
    @Value(value="${fh.web.guests.authenticate.path:authenticateGuest}")
    private String authenticateGuestPath;
    @Value(value="${server.logout.path:logout}")
    private String logoutPath;
    private SecurityProviderInitializer securityProviderInitializer;
    @Autowired(required=false)
    private List<FhWebConfiguration> fhWebConfigurations = new ArrayList<FhWebConfiguration>();
    @Autowired
    SingleLoginLockManager singleLoginManager;

    @Autowired
    public void setSecurityProviderInitializer(SecurityProviderInitializer securityProviderInitializer) {
        this.securityProviderInitializer = securityProviderInitializer;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        ((FormLoginConfigurer)http.formLogin().loginPage("/login").failureUrl("/login?error")).permitAll();
        http.httpBasic();
        http.cors();
        http.sessionManagement().maximumSessions(this.singleLoginManager.isTrunedOn() ? 1 : -1).sessionRegistry(this.sessionRegistry()).expiredUrl("/login");
        http.logout().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/" + this.logoutPath)).logoutSuccessUrl("/login?logout").deleteCookies(new String[]{"JSESSIONID"}).invalidateHttpSession(true).permitAll();
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry urlRegistry = http.authorizeRequests();
        if (!this.guestsAllowed) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.antMatchers(new String[]{"/", "/index", "/socketForms"})).authenticated();
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.antMatchers(new String[]{"/" + this.authenticateGuestPath})).authenticated();
        HashSet<String> publicUrls = new HashSet<String>();
        publicUrls.add("/" + this.logoutPath);
        this.fhWebConfigurations.forEach(fhWebConfiguration -> publicUrls.addAll(fhWebConfiguration.permitedToAllRequestUrls()));
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.antMatchers(publicUrls.toArray(new String[0]))).permitAll();
        http.addFilterBefore((Filter)this.customSecurityFilter(), UsernamePasswordAuthenticationFilter.class);
        this.fhWebConfigurations.forEach(fhWebConfiguration -> fhWebConfiguration.configure(http));
        if (!this.guestsAllowed) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
        }
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        HashSet defaultUsers = new HashSet();
        this.fhWebConfigurations.forEach(fhWebConfiguration -> defaultUsers.addAll(fhWebConfiguration.getDefaultUsers()));
        this.securityProviderInitializer.configureAuthentication(auth, new ArrayList(defaultUsers));
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder(8);
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new SessionRegistryImpl();
    }

    @Bean
    public SecurityFilter customSecurityFilter() {
        SecurityFilter sf = new SecurityFilter();
        sf.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler("/login?error"));
        return sf;
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

