/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app.config.repository;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.data.repository.config.RepositoryBeanDefinitionRegistrarSupport;
import org.springframework.data.repository.config.RepositoryConfigurationDelegate;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationUtils;
import org.springframework.util.Assert;
import pl.fhframework.app.config.repository.EnableFhJpaRepositories;
import pl.fhframework.app.config.repository.FhAnnotationRepositoryConfigurationSource;

class FhJpaRepositoriesRegistrar
extends RepositoryBeanDefinitionRegistrarSupport {
    private ResourceLoader resourceLoader;
    private Environment environment;

    FhJpaRepositoriesRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableFhJpaRepositories.class;
    }

    protected RepositoryConfigurationExtension getExtension() {
        return new JpaRepositoryConfigExtension();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry, BeanNameGenerator generator) {
        Assert.notNull((Object)this.resourceLoader, (String)"ResourceLoader must not be null!");
        Assert.notNull((Object)metadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        if (metadata.getAnnotationAttributes(this.getAnnotation().getName()) == null) {
            return;
        }
        FhAnnotationRepositoryConfigurationSource configurationSource = new FhAnnotationRepositoryConfigurationSource(metadata, this.getAnnotation(), this.resourceLoader, this.environment, registry, generator);
        RepositoryConfigurationExtension extension = this.getExtension();
        RepositoryConfigurationUtils.exposeRegistration((RepositoryConfigurationExtension)extension, (BeanDefinitionRegistry)registry, (RepositoryConfigurationSource)configurationSource);
        RepositoryConfigurationDelegate delegate = new RepositoryConfigurationDelegate((RepositoryConfigurationSource)configurationSource, this.resourceLoader, this.environment);
        delegate.registerRepositoriesIn(registry, extension);
    }
}

