/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app.menu;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import pl.fhframework.ISystemUseCase;
import pl.fhframework.SessionManager;
import pl.fhframework.annotations.Action;
import pl.fhframework.app.menu.MenuForm;
import pl.fhframework.core.i18n.IUseCase18nListener;
import pl.fhframework.core.uc.IUseCaseCancelEvent;
import pl.fhframework.core.uc.UseCase;
import pl.fhframework.core.uc.UseCaseContainer;
import pl.fhframework.event.EventRegistry;
import pl.fhframework.event.dto.NotificationEvent;
import pl.fhframework.menu.MenuElement;
import pl.fhframework.menu.MenuManager;

@UseCase
public class MenuUC
implements ISystemUseCase,
IUseCase18nListener {
    public static final String MENU_CONTAINER_ID = "menuForm";
    @Autowired
    private MenuManager menuManager;
    @Autowired
    private EventRegistry eventRegistry;
    private MenuForm.Model model;
    private MenuForm form;

    public void start() {
        List menuElements = this.menuManager.getMenuModel(SessionManager.getUserSession().getSystemUser());
        this.model = new MenuForm.Model();
        this.model.setMenuElements(menuElements);
        this.form = (MenuForm)this.showForm(MenuForm.class, this.model);
    }

    @Action
    public void menuElementClicked(MenuElement element) {
        if (!element.isGroupingElement()) {
            if (element.isActive()) {
                UseCaseContainer.UseCaseContext currentUseCaseContext = this.getUserSession().getUseCaseContainer().getCurrentUseCaseContext();
                if (currentUseCaseContext != null && currentUseCaseContext.getUseCase() instanceof IUseCaseCancelEvent) {
                    ((IUseCaseCancelEvent)currentUseCaseContext.getUseCase()).onCancel(one -> this.getUserSession().runUseCase(element.getRef(), element.getInputFactory()));
                } else {
                    this.getUserSession().runUseCase(element.getRef(), element.getInputFactory());
                }
            } else {
                this.eventRegistry.fireNotificationEvent(NotificationEvent.Level.WARNING, "Cloud server is inactive");
            }
        }
    }

    public String getContainerId() {
        return MENU_CONTAINER_ID;
    }

    public void onSessionLanguageChange() {
        List menuElements = this.menuManager.getMenuModel(SessionManager.getUserSession().getSystemUser());
        this.model.setMenuElements(menuElements);
        this.hideForm(this.form);
        this.showForm(this.form);
    }
}

